/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import java.io.File;
import java.net.URI;
import m2m.backend.project.M2MProject;
import m2m.frontend.Activator;
import m2m.frontend.actions.M2MAction;
import m2m.frontend.view.Editor;
import m2m.frontend.view.M2MFileStoreEditorInput;
import m2m.frontend.view.NavigationView;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewProjectAction
extends M2MAction {
    boolean empty;

    public NewProjectAction(IWorkbenchWindow window, String label, boolean empty) {
        super(window, label);
        this.empty = empty;
        if (empty) {
            this.setId("m2mgui.new");
            this.setActionDefinitionId("m2mgui.new");
        } else {
            this.setId("m2mgui.newfromfile");
            this.setActionDefinitionId("m2mgui.newfromfile");
        }
        this.setImageDescriptor(Activator.getImageDescriptor("/icons/new.gif"));
    }

    public void run() {
        String fileName = new String();
        FileDialog dialog = new FileDialog(this.window.getShell(), 8192);
        dialog.setText("Create new project");
        String[] filterExt = new String[]{"*.m2m"};
        dialog.setFilterExtensions(filterExt);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        if ((path.lastIndexOf(".") == -1 ? "" : path.substring(path.lastIndexOf(".") + 1, path.length())).equalsIgnoreCase(dialog.getFilterExtensions()[dialog.getFilterIndex()].substring(2))) {
            fileName = path;
        } else {
            String filterExtension = dialog.getFilterExtensions()[dialog.getFilterIndex()];
            fileName = String.valueOf(path) + filterExtension.substring(1, filterExtension.length());
        }
        File file = new File(fileName);
        String octaveFileName = "";
        if (!file.exists()) {
            if (!this.empty) {
                FileDialog dlg = new FileDialog(this.window.getShell(), 4096);
                dlg.setText("Choose the Octave/Matlab file");
                String[] filterExt1 = new String[]{"*.m"};
                String[] filterNames = new String[]{"Source file (*.m)"};
                dlg.setFilterExtensions(filterExt1);
                dlg.setFilterNames(filterNames);
                octaveFileName = dlg.open();
                if (octaveFileName == null) {
                    return;
                }
                if (octaveFileName.isEmpty()) {
                    return;
                }
            }
            this.createProject(file, octaveFileName);
        } else {
            MessageBox mess = new MessageBox(this.window.getShell(), 33);
            mess.setMessage("The project file already exists! Pleae choose another one.");
            mess.setText("Error");
            mess.open();
        }
    }

    private void createProject(File file, String octaveFileName) {
        M2MProject project = new M2MProject();
        if (this.empty) {
            if (!project.CreateEmptyProject(file.getAbsolutePath())) {
                MessageBox mess = new MessageBox(this.window.getShell(), 33);
                mess.setMessage("The project can not be created. It seems that there is a problem accessing the choosen directory.");
                mess.setText("Error");
                mess.open();
                return;
            }
        } else if (!project.CreateNewProjectFromMath(file.getAbsolutePath(), octaveFileName)) {
            MessageBox mess = new MessageBox(this.window.getShell(), 33);
            mess.setMessage("The project can not be created. It seems that there is a problem accessing the choosen directory.");
            mess.setText("Error");
            mess.open();
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IFileStore fileStore = EFS.getStore((URI)file.toURI());
            Editor editor = (Editor)page.openEditor((IEditorInput)new M2MFileStoreEditorInput(fileStore, project), "m2mgui.editor", true);
            NavigationView.addList(file.getAbsolutePath());
            editor.setParseDone(true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

