/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import java.io.File;
import java.net.URI;
import m2m.backend.octaveparser.ParsingException;
import m2m.backend.project.M2MProject;
import m2m.frontend.Activator;
import m2m.frontend.ApplicationActionBarAdvisor;
import m2m.frontend.GUIProperties;
import m2m.frontend.actions.M2MAction;
import m2m.frontend.actions.ReOpenFile;
import m2m.frontend.view.Editor;
import m2m.frontend.view.M2MFileStoreEditorInput;
import m2m.frontend.view.NavigationView;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class OpenFileAction
extends M2MAction {
    public OpenFileAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setId("m2mgui.open");
        this.setActionDefinitionId("m2mgui.open");
        this.setImageDescriptor(Activator.getImageDescriptor("/icons/open.gif"));
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.window.getShell(), 4096);
        dialog.setText("Open File");
        String[] filterExt = new String[]{"*.m2m"};
        String[] filterNames = new String[]{"Math2Mat project (*.m2m)"};
        dialog.setFilterExtensions(filterExt);
        dialog.setFilterNames(filterNames);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        if (!OpenFileAction.openFile(path)) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"File error", (String)"File project is corrupted\nThe source file path does not refer to a file");
        }
    }

    public static boolean openFile(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (!OpenFileAction.createProject(file)) {
            return false;
        }
        GUIProperties GUIProps = GUIProperties.getReference();
        String[] rof = new String[5];
        rof = GUIProps.getReOpenFile();
        int k = 4;
        if (rof != null) {
            int i = 0;
            while (i < rof.length) {
                if (rof[i].equalsIgnoreCase(path)) {
                    k = i;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < rof.length) {
                GUIProps.setReOpenFileAtIndex(rof[i].equalsIgnoreCase("null") ? "No file" : rof[i], i);
                ++i;
            }
            i = k;
            while (i > 0) {
                GUIProps.setReOpenFileAtIndex(rof[i - 1], i);
                --i;
            }
        }
        GUIProps.setReOpenFileAtIndex(path, 0);
        GUIProps.writeSettings();
        ReOpenFile[] rofActionTab = ApplicationActionBarAdvisor.getInstance().getReOpenFile();
        int i = 0;
        while (i < rofActionTab.length) {
            rofActionTab[i].setPath(GUIProps.getReOpenFileAtIndex(i) == null ? "No File" : GUIProps.getReOpenFileAtIndex(i));
            ++i;
        }
        ApplicationActionBarAdvisor.getInstance().repopulateFileMenu();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createProject(File file) {
        M2MProject m2mProject = new M2MProject();
        m2mProject.openProject(file.getAbsolutePath());
        boolean reload = false;
        if (!m2mProject.sourceFileExist()) {
            m2mProject.checkFolders();
            m2mProject.restoreOctave();
        } else if (!m2mProject.checkSourceFile()) {
            if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)"The Octave seems to have been modified outside of Math2mat. Reload?")) {
                reload = true;
            } else {
                m2mProject.restoreOctave();
            }
        }
        if (m2mProject.getSourceFile() == null) return false;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IFileStore fileStore = EFS.getStore((URI)file.toURI());
            IEditorReference[] myReferences = page.findEditors((IEditorInput)new FileStoreEditorInput(fileStore), "m2mgui.editor", 2);
            int i = 0;
            while (true) {
                if (i >= myReferences.length) {
                    page.openEditor((IEditorInput)new M2MFileStoreEditorInput(fileStore, m2mProject), "m2mgui.editor", true);
                    NavigationView.addList(file.getAbsolutePath());
                    try {
                        page.showView("m2mgui.view.m2mConsole");
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                Editor editor = (Editor)myReferences[i].getEditor(true);
                if (editor.getM2MProject().compare(m2mProject)) {
                    page.activate((IWorkbenchPart)editor);
                    return true;
                }
                ++i;
            }
            Editor editor = (Editor)page.getActiveEditor();
            if (!reload) {
                editor.setParseDone(true);
                return true;
            }
            editor.getM2MProject().clearStructTreatment();
            editor.setParseDone(true);
            try {
                editor.getM2MProject().getStructTreatment().parse(editor.getStyledText().getText());
                editor.getM2MProject().getStructTreatment().modifyNumType(editor.getM2MProject().getProperties().getOptimisationProperties().getOptimisationDataType());
                return true;
            }
            catch (ParsingException parsingException) {
                editor.setParseDone(false);
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }
}

