/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import m2m.backend.project.M2MProject;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Element;
import m2m.backend.structure.Equal;
import m2m.backend.structure.Function;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.LoopFor;
import m2m.backend.structure.LoopWhile;
import m2m.backend.structure.Multiplexer;
import m2m.backend.structure.Operation;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.structure.StructTreatment;
import m2m.backend.structure.Variable;
import m2m.frontend.dynamicview.model.Connection;
import m2m.frontend.dynamicview.model.GraphicFunction;
import m2m.frontend.dynamicview.model.GraphicIf;
import m2m.frontend.dynamicview.model.GraphicLoop;
import m2m.frontend.dynamicview.model.GraphicLoopIterator;
import m2m.frontend.dynamicview.model.GraphicOperation;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.PointConnection;
import m2m.frontend.dynamicview.model.Schema;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class Model {
    private Schema schema = new Schema();
    public static final int SPACE = 50;
    public static final int SPACE_INTERN_BLOC = 40;

    public Model(StructTreatment treatment, M2MProject m2mProject) {
        this.schema.setName("Prototype Polynome");
        this.schema.setLayout(new Rectangle(0, 0, 1000, 1000));
        this.schema.setproject(m2mProject);
        this.createFunction(treatment.getTop(), this.schema);
        this.schema.setMaxDepth(this.schema.getAllNodes());
    }

    private void createFunction(Function function, Node graphicParent) {
        int positionX = 50;
        int positionY = 0;
        Vector<Vector<Element>> elementLevel = new Vector<Vector<Element>>();
        Vector<Vector<Element>> conditions = new Vector<Vector<Element>>();
        for (Element element : function.getInput()) {
            PointConnection pointConnection = new PointConnection();
            pointConnection.setName(element.getName());
            pointConnection.setElement(element);
            pointConnection.setLayout(new Rectangle(positionX, positionY += 50, 10, 10));
            graphicParent.addChild(pointConnection);
        }
        for (Element element : function.getOutput()) {
            PointConnection pointConnection = new PointConnection();
            pointConnection.setName(element.getName());
            pointConnection.setElement(element);
            graphicParent.addChild(pointConnection);
        }
        GraphicFunction graphicFunction = new GraphicFunction();
        graphicFunction.setName(function.getName());
        graphicFunction.setElement(function);
        graphicParent.addChild(graphicFunction);
        Node firstInputNode = this.getGraphicalNodeInParent(function.getInput().firstElement(), graphicParent);
        if (firstInputNode != null) {
            graphicFunction.getLayout().setLocation(firstInputNode.getLayout().x + firstInputNode.getLayout().width + 50, firstInputNode.getLayout().y);
        } else {
            graphicFunction.getLayout().setLocation(50, 50);
        }
        for (Element element : function.getBody()) {
            if (element instanceof Assignment) {
                this.createAssignment((Assignment)element, graphicFunction, elementLevel);
                continue;
            }
            if (element instanceof IfThenElse) {
                conditions.add(this.createIfThenElse((IfThenElse)element, graphicFunction, elementLevel));
                continue;
            }
            if (element instanceof Multiplexer) {
                this.createMultiplexer((Multiplexer)element, graphicFunction, elementLevel, conditions);
                continue;
            }
            if (element instanceof Operation) {
                this.createOperation((Operation)element, graphicFunction, elementLevel);
                continue;
            }
            if (element instanceof LoopFor) {
                this.createLoopFor((LoopFor)element, graphicFunction, elementLevel);
                continue;
            }
            if (!(element instanceof LoopWhile)) continue;
            this.createLoopWhile((LoopWhile)element, graphicFunction, elementLevel);
        }
        for (Vector vector : elementLevel) {
            this.locateNodesLevel(vector, graphicFunction);
        }
        graphicFunction.setFullSize(graphicFunction.getLayout().width, graphicFunction.getLayout().height);
        graphicFunction.setReductSize(80, 15);
        positionX = graphicFunction.getLayout().x + graphicFunction.getLayout().width + 50;
        positionY = graphicFunction.getLayout().y + 50;
        for (Element element : function.getOutput()) {
            Node node = this.getGraphicalNodeInParent(element, graphicParent);
            node.setLayout(new Rectangle(positionX, positionY, 10, 10));
            positionY += 50;
            graphicFunction.addOutputPointConnection((PointConnection)node);
        }
    }

    private void createLoopFor(LoopFor loopFor, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        Vector<Vector<Element>> elementLevelFor = new Vector<Vector<Element>>();
        Vector<Vector<Element>> conditions = new Vector<Vector<Element>>();
        GraphicLoop graphicFor = new GraphicLoop();
        graphicFor.setName(loopFor.getName());
        graphicFor.setElement(loopFor);
        graphicParent.addChild(graphicFor);
        graphicFor.getLayout().setLocation(0, 0);
        int levelMax = 0;
        for (Element element : loopFor.getInput()) {
            Node nodeIn = this.getGraphicalNodeInParent(element, graphicParent);
            if (nodeIn instanceof GraphicLoopIterator) {
                nodeIn = ((GraphicLoopIterator)nodeIn).getOutputPointConnection();
            }
            if (nodeIn == null) continue;
            levelMax = Math.max(levelMax, nodeIn.getLevel() + 1);
            PointConnection pointConnection = new PointConnection();
            pointConnection.setName(element.getName());
            pointConnection.setElement(element);
            pointConnection.setLayout(new Rectangle(0, Math.max(40, (nodeIn.getLayout().y - graphicParent.getLayout().y) / 10), 10, 10));
            pointConnection.setLevel(0);
            if (pointConnection.getLevel() > elementLevelFor.size() - 1) {
                elementLevelFor.add(new Vector());
            }
            ((Vector)elementLevelFor.elementAt(pointConnection.getLevel())).add(element);
            graphicFor.addChild(pointConnection);
            new Connection(nodeIn, pointConnection);
        }
        graphicFor.setLevel(levelMax);
        if (graphicFor.getLevel() > elementLevel.size() - 1) {
            elementLevel.add(new Vector());
        }
        elementLevel.elementAt(graphicFor.getLevel()).add(loopFor);
        for (Element element : loopFor.getOutput()) {
            if (this.getGraphicalNodeInParent(element, graphicParent) == null) {
                PointConnection pointConnection = new PointConnection();
                pointConnection.setName(element.getName());
                pointConnection.setElement(element);
                graphicParent.addChild(pointConnection);
            }
            this.getGraphicalNodeInParent(element, graphicParent).setLevel(graphicFor.getLevel());
        }
        GraphicLoopIterator iter = new GraphicLoopIterator();
        iter.setEndCondition(loopFor.getEnd().getType().equals("const") ? String.valueOf(loopFor.getEnd().getVal()) : loopFor.getEnd().getName());
        iter.setIncrementation(loopFor.getIncr().getType().equals("const") ? String.valueOf(loopFor.getIncr().getVal()) : loopFor.getIncr().getName());
        iter.setStartInitialisation(loopFor.getStart().getType().equals("const") ? String.valueOf(loopFor.getStart().getVal()) : loopFor.getStart().getName());
        iter.setIterOperation(loopFor.getIterOperation());
        if (!loopFor.getEnd().getType().equals("const")) {
            iter.addConditionNodes(this.getGraphicalNodeInParent(loopFor.getEnd(), graphicFor));
        }
        if (!loopFor.getIncr().getType().equals("const")) {
            iter.addConditionNodes(this.getGraphicalNodeInParent(loopFor.getIncr(), graphicFor));
        }
        if (!loopFor.getStart().getType().equals("const")) {
            iter.addConditionNodes(this.getGraphicalNodeInParent(loopFor.getStart(), graphicFor));
        }
        iter.setName(loopFor.getInternalVars().get(0).getName());
        iter.setLayout(new Rectangle(0, 0, 40, 35));
        graphicFor.addChild(iter);
        iter.setLevel(1);
        iter.setElement(loopFor.getInternalVars().get(0));
        if (elementLevelFor.isEmpty()) {
            elementLevelFor.add(new Vector());
        }
        if (iter.getLevel() > elementLevelFor.size() - 1) {
            elementLevelFor.add(new Vector());
        }
        ((Vector)elementLevelFor.elementAt(iter.getLevel())).add(iter.getElement());
        PointConnection pc2 = new PointConnection();
        pc2.setName(loopFor.getInternalVars().get(0).getName());
        pc2.setElement(loopFor.getInternalVars().get(0));
        pc2.setLayout(new Rectangle(0, 0, 10, 10));
        graphicFor.addChild(pc2);
        pc2.setLevel(iter.getLevel());
        iter.setOutputPointConnexion(pc2);
        new Connection(iter.getOutPoint(), pc2);
        for (Element element : loopFor.getBody()) {
            if (element instanceof Assignment) {
                this.createAssignment((Assignment)element, graphicFor, elementLevelFor);
                continue;
            }
            if (element instanceof IfThenElse && element.getName().contains("loopfor")) {
                this.createIfThenElseFor((IfThenElse)element, graphicFor, elementLevelFor);
                continue;
            }
            if (element instanceof IfThenElse) {
                conditions.add(this.createIfThenElse((IfThenElse)element, graphicFor, elementLevelFor));
                continue;
            }
            if (element instanceof Multiplexer) {
                this.createMultiplexer((Multiplexer)element, graphicFor, elementLevelFor, conditions);
                continue;
            }
            if (element instanceof Operation) {
                this.createOperation((Operation)element, graphicFor, elementLevelFor);
                continue;
            }
            if (element instanceof LoopFor) {
                this.createLoopFor((LoopFor)element, graphicFor, elementLevelFor);
                continue;
            }
            if (!(element instanceof LoopWhile)) continue;
            this.createLoopWhile((LoopWhile)element, graphicFor, elementLevelFor);
        }
        for (Vector vector : elementLevelFor) {
            this.locateNodesLevel(vector, graphicFor);
        }
        graphicFor.setFullSize(graphicFor.getLayout().width, graphicFor.getLayout().height);
        graphicFor.setReductSize(80, 15);
    }

    private void createLoopWhile(LoopWhile loopWhile, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        PointConnection pc;
        Vector<Vector<Element>> elementLevelWhile = new Vector<Vector<Element>>();
        Vector<Vector<Element>> conditions = new Vector<Vector<Element>>();
        GraphicLoop graphicWhile = new GraphicLoop();
        graphicWhile.setName(loopWhile.getName());
        graphicWhile.setElement(loopWhile);
        graphicParent.addChild(graphicWhile);
        graphicWhile.getLayout().setLocation(0, 0);
        int levelMax = 0;
        for (Element element : loopWhile.getInput()) {
            Node nodeIn = this.getGraphicalNodeInParent(element, graphicParent);
            if (nodeIn instanceof GraphicLoopIterator) {
                nodeIn = ((GraphicLoopIterator)nodeIn).getOutputPointConnection();
            }
            if (nodeIn == null) continue;
            levelMax = Math.max(levelMax, nodeIn.getLevel() + 1);
            pc = new PointConnection();
            pc.setName(element.getName());
            pc.setElement(element);
            pc.setLayout(new Rectangle(0, Math.max(40, (nodeIn.getLayout().y - graphicParent.getLayout().y) / 10), 10, 10));
            pc.setLevel(0);
            if (pc.getLevel() > elementLevelWhile.size() - 1) {
                elementLevelWhile.add(new Vector());
            }
            elementLevelWhile.elementAt(pc.getLevel()).add(element);
            graphicWhile.addChild(pc);
            new Connection(nodeIn, pc);
        }
        graphicWhile.setLevel(levelMax);
        if (graphicWhile.getLevel() > elementLevel.size() - 1) {
            elementLevel.add(new Vector());
        }
        elementLevel.elementAt(graphicWhile.getLevel()).add(loopWhile);
        for (Element element : loopWhile.getOutput()) {
            if (this.getGraphicalNodeInParent(element, graphicParent) == null) {
                pc = new PointConnection();
                pc.setName(element.getName());
                pc.setElement(element);
                graphicParent.addChild(pc);
            }
            this.getGraphicalNodeInParent(element, graphicParent).setLevel(graphicWhile.getLevel());
        }
        for (Element element : loopWhile.getBody()) {
            if (element instanceof Assignment) {
                this.createAssignment((Assignment)element, graphicWhile, elementLevelWhile);
                continue;
            }
            if (element instanceof IfThenElse && element.getName().contains("loopwhile")) {
                this.createIfThenElseWhile((IfThenElse)element, graphicWhile, elementLevelWhile);
                continue;
            }
            if (element instanceof IfThenElse) {
                conditions.add(this.createIfThenElse((IfThenElse)element, graphicWhile, elementLevelWhile));
                continue;
            }
            if (element instanceof Multiplexer) {
                this.createMultiplexer((Multiplexer)element, graphicWhile, elementLevelWhile, conditions);
                continue;
            }
            if (element instanceof Operation) {
                this.createOperation((Operation)element, graphicWhile, elementLevelWhile);
                continue;
            }
            if (element instanceof LoopFor) {
                this.createLoopFor((LoopFor)element, graphicWhile, elementLevelWhile);
                continue;
            }
            if (!(element instanceof LoopWhile)) continue;
            this.createLoopWhile((LoopWhile)element, graphicWhile, elementLevelWhile);
        }
        for (Node node : graphicWhile.getChildrenArray()) {
            if (!(node instanceof GraphicIf) || !node.getName().contains("loopwhile")) continue;
            for (Element e : loopWhile.getCond()) {
                for (Element e1 : ((Operation)e).getInput()) {
                    Node condNode = this.getGraphicalNodeInParent(e1, graphicWhile);
                    if (condNode != null) {
                        ((GraphicIf)node).addConditionNodes(condNode);
                        continue;
                    }
                    condNode = this.getGraphicalNode(e1);
                    if (condNode == null) continue;
                    ((GraphicIf)node).addConditionNodes(condNode);
                }
            }
        }
        for (Vector vector : elementLevelWhile) {
            this.locateNodesLevel(vector, graphicWhile);
        }
        graphicWhile.setFullSize(graphicWhile.getLayout().width, graphicWhile.getLayout().height);
        graphicWhile.setReductSize(80, 15);
    }

    private void createAssignment(Assignment assignment, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        Node nodeOut;
        Element elementIn = assignment.getInputAt(0);
        Element elementOut = assignment.getOutputAt(0);
        Node nodeIn = this.getGraphicalNode(elementIn);
        if (nodeIn instanceof GraphicLoopIterator) {
            nodeIn = ((GraphicLoopIterator)nodeIn).getOutputPointConnection();
        }
        if ((nodeOut = this.getGraphicalNode(elementOut)) == null) {
            PointConnection pc = new PointConnection();
            pc.setName(elementOut.getName());
            pc.setElement(elementOut);
            graphicParent.addChild(pc);
            if (nodeIn == null) {
                pc.setLevel(0);
                pc.setIsConstant(true);
                pc.setName(String.valueOf(((SimpleVariable)elementIn).getVal()));
                pc.setLayout(new Rectangle(0, 0, 10, 10));
            } else {
                nodeIn = this.getGraphicalNodeInParent(elementIn, graphicParent);
                if (nodeIn != null) {
                    pc.setLevel(nodeIn.getLevel() + 1);
                    if (pc.getLevel() > elementLevel.size() - 1) {
                        elementLevel.add(new Vector());
                    }
                    pc.setLayout(new Rectangle(0, 0, 10, 10));
                } else {
                    nodeIn = this.getGraphicalNodeInParent(elementIn, graphicParent.getParent());
                    pc.setLevel(0);
                    if (pc.getLevel() > elementLevel.size() - 1) {
                        elementLevel.add(new Vector());
                    }
                    pc.setLayout(new Rectangle(0, Math.max(40, (nodeIn.getLayout().y - graphicParent.getLayout().y) / 10), 10, 10));
                }
                new Connection(nodeIn, pc);
                elementLevel.elementAt(pc.getLevel()).add(assignment);
            }
        } else {
            new Connection(nodeIn, nodeOut);
        }
    }

    private Vector<Element> createIfThenElse(IfThenElse ifThenElse, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        Vector<Vector<Element>> conditions = new Vector<Vector<Element>>();
        for (Element element : ifThenElse.getBodyTrue()) {
            if (element instanceof Assignment) {
                this.createAssignment((Assignment)element, graphicParent, elementLevel);
                continue;
            }
            if (element instanceof IfThenElse) {
                conditions.add(this.createIfThenElse((IfThenElse)element, graphicParent, elementLevel));
                continue;
            }
            if (element instanceof Multiplexer) {
                this.createMultiplexer((Multiplexer)element, graphicParent, elementLevel, conditions);
                continue;
            }
            if (element instanceof Operation) {
                this.createOperation((Operation)element, graphicParent, elementLevel);
                continue;
            }
            if (element instanceof LoopFor) {
                this.createLoopFor((LoopFor)element, graphicParent, elementLevel);
                continue;
            }
            if (!(element instanceof LoopWhile)) continue;
            this.createLoopWhile((LoopWhile)element, graphicParent, elementLevel);
        }
        for (Element element : ifThenElse.getBodyFalse()) {
            if (element instanceof Assignment) {
                this.createAssignment((Assignment)element, graphicParent, elementLevel);
                continue;
            }
            if (element instanceof IfThenElse) {
                conditions.add(this.createIfThenElse((IfThenElse)element, graphicParent, elementLevel));
                continue;
            }
            if (element instanceof Multiplexer) {
                this.createMultiplexer((Multiplexer)element, graphicParent, elementLevel, conditions);
                continue;
            }
            if (element instanceof Operation) {
                this.createOperation((Operation)element, graphicParent, elementLevel);
                continue;
            }
            if (!(element instanceof LoopFor)) continue;
            this.createLoopFor((LoopFor)element, graphicParent, elementLevel);
        }
        return ifThenElse.getCond();
    }

    private void createIfThenElseFor(IfThenElse ifThenElse, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        PointConnection pc;
        Vector<Element> condition = new Vector<Element>();
        Equal cond = new Equal();
        cond.addOutput(((Operation)ifThenElse.getCond().firstElement()).getOutputAt(0));
        cond.addInput(((LoopFor)graphicParent.getElement()).getInternalVars().firstElement());
        cond.addInput(((LoopFor)graphicParent.getElement()).getStart());
        condition.add(cond);
        GraphicIf graphicIf = new GraphicIf();
        graphicIf.setName(ifThenElse.getName());
        graphicIf.setLayout(new Rectangle(0, 0, 41, 40));
        graphicIf.setElement(ifThenElse);
        graphicIf.setCondition(this.getConditionString(condition));
        graphicParent.addChild(graphicIf);
        graphicIf.addConditionNodes(this.getGraphicalNodeInParent(((Operation)condition.firstElement()).getInput().firstElement(), graphicParent));
        Node condNode = this.getGraphicalNode(((Operation)condition.firstElement()).getInputAt(1));
        if (condNode != null) {
            graphicIf.addConditionNodes(condNode);
        }
        Node nodeIn1 = this.getGraphicalNodeInParent(((Assignment)ifThenElse.getBodyTrue().firstElement()).getInputAt(0), graphicParent);
        Node nodeIn2 = this.getGraphicalNodeInParent(((Assignment)ifThenElse.getBodyFalse().firstElement()).getInputAt(0), graphicParent);
        if (nodeIn1 instanceof GraphicLoopIterator) {
            nodeIn1 = ((GraphicLoopIterator)nodeIn1).getOutputPointConnection();
        }
        if (nodeIn2 instanceof GraphicLoopIterator) {
            nodeIn2 = ((GraphicLoopIterator)nodeIn2).getOutputPointConnection();
        }
        if (nodeIn2 == null) {
            Element elementIn = ((Assignment)ifThenElse.getBodyFalse().firstElement()).getInputAt(0);
            pc = new PointConnection();
            pc.setName(elementIn.getName());
            pc.setLevel(nodeIn1.getLevel());
            pc.setLayout(new Rectangle(0, 0, 10, 10));
            pc.setElement(elementIn);
            graphicParent.addChild(pc);
            nodeIn2 = pc;
        }
        graphicIf.setLevel(Math.max(nodeIn1.getLevel(), nodeIn2.getLevel()) + 1);
        if (graphicIf.getLevel() > elementLevel.size() - 1) {
            elementLevel.add(new Vector());
        }
        elementLevel.elementAt(graphicIf.getLevel()).add(ifThenElse);
        Element elementOut = ((Assignment)ifThenElse.getBodyTrue().firstElement()).getOutputAt(0);
        pc = new PointConnection();
        pc.setName(elementOut.getName());
        pc.setLevel(graphicIf.getLevel());
        pc.setElement(elementOut);
        pc.setLayout(new Rectangle(0, 0, 10, 10));
        graphicParent.addChild(pc);
        graphicIf.setOutputPointConnexion(pc);
        new Connection(nodeIn1, graphicIf.getTruePoint());
        new Connection(nodeIn2, graphicIf.getFalsePoint());
        new Connection(graphicIf.getOutPoint(), pc);
    }

    private void createIfThenElseWhile(IfThenElse ifThenElse, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        PointConnection pc;
        Vector<Element> condition = ifThenElse.getCond();
        GraphicIf graphicIf = new GraphicIf();
        graphicIf.setName(ifThenElse.getName());
        graphicIf.setLayout(new Rectangle(0, 0, 41, 40));
        graphicIf.setElement(ifThenElse);
        graphicIf.setCondition(this.getConditionString(condition));
        graphicParent.addChild(graphicIf);
        Node nodeIn1 = this.getGraphicalNodeInParent(((Assignment)ifThenElse.getBodyTrue().firstElement()).getInputAt(0), graphicParent);
        Node nodeIn2 = this.getGraphicalNodeInParent(((Assignment)ifThenElse.getBodyFalse().firstElement()).getInputAt(0), graphicParent);
        if (nodeIn1 instanceof GraphicLoopIterator) {
            nodeIn1 = ((GraphicLoopIterator)nodeIn1).getOutputPointConnection();
        }
        if (nodeIn2 instanceof GraphicLoopIterator) {
            nodeIn2 = ((GraphicLoopIterator)nodeIn2).getOutputPointConnection();
        }
        if (nodeIn2 == null) {
            Element elementIn = ((Assignment)ifThenElse.getBodyFalse().firstElement()).getInputAt(0);
            pc = new PointConnection();
            pc.setName(elementIn.getName());
            pc.setLevel(nodeIn1.getLevel());
            pc.setLayout(new Rectangle(0, 0, 10, 10));
            pc.setElement(elementIn);
            graphicParent.addChild(pc);
            nodeIn2 = pc;
        }
        graphicIf.setLevel(Math.max(nodeIn1.getLevel(), nodeIn2.getLevel()) + 1);
        if (graphicIf.getLevel() > elementLevel.size() - 1) {
            elementLevel.add(new Vector());
        }
        elementLevel.elementAt(graphicIf.getLevel()).add(ifThenElse);
        Element elementOut = ((Assignment)ifThenElse.getBodyTrue().firstElement()).getOutputAt(0);
        pc = new PointConnection();
        pc.setName(elementOut.getName());
        pc.setLevel(graphicIf.getLevel());
        pc.setElement(elementOut);
        pc.setLayout(new Rectangle(0, 0, 10, 10));
        graphicParent.addChild(pc);
        graphicIf.setOutputPointConnexion(pc);
        new Connection(nodeIn1, graphicIf.getTruePoint());
        new Connection(nodeIn2, graphicIf.getFalsePoint());
        new Connection(graphicIf.getOutPoint(), pc);
    }

    private void createMultiplexer(Multiplexer mux, Node graphicParent, Vector<Vector<Element>> elementLevel, Vector<Vector<Element>> conditions) {
        Vector<Element> condition = new Vector<Element>();
        String variableConditionName = mux.getSel().getName();
        for (Vector<Element> cond : conditions) {
            if (!((Operation)cond.lastElement()).getOutputAt(0).getName().equalsIgnoreCase(variableConditionName)) continue;
            condition.addAll(cond);
        }
        GraphicIf ifThenElse = new GraphicIf();
        ifThenElse.setName(mux.getName());
        ifThenElse.setLayout(new Rectangle(0, 0, 41, 40));
        ifThenElse.setElement(mux);
        ifThenElse.setCondition(this.getConditionString(condition));
        graphicParent.addChild(ifThenElse);
        Vector<Element> inputCondition = new Vector<Element>();
        Vector<Element> outputCondition = new Vector<Element>();
        for (Element element : condition) {
            for (Element input : ((Operation)element).getInput()) {
                if (inputCondition.contains(input) || ((Variable)input).getType().equals("const")) continue;
                inputCondition.add(input);
            }
            outputCondition.addAll(((Operation)element).getOutput());
        }
        inputCondition.removeAll(outputCondition);
        for (Element element : inputCondition) {
            ifThenElse.addConditionNodes(this.getGraphicalNodeInParent(element, graphicParent));
        }
        Node nodeIn1 = this.getGraphicalNodeInParent(mux.getInputAt(0), graphicParent);
        Node nodeIn2 = this.getGraphicalNodeInParent(mux.getInputAt(1), graphicParent);
        if (nodeIn1 instanceof GraphicLoopIterator) {
            nodeIn1 = ((GraphicLoopIterator)nodeIn1).getOutputPointConnection();
        }
        if (nodeIn2 instanceof GraphicLoopIterator) {
            nodeIn2 = ((GraphicLoopIterator)nodeIn2).getOutputPointConnection();
        }
        ifThenElse.setLevel(Math.max(nodeIn1.getLevel(), nodeIn2.getLevel()) + 1);
        if (ifThenElse.getLevel() > elementLevel.size() - 1) {
            elementLevel.add(new Vector());
        }
        elementLevel.elementAt(ifThenElse.getLevel()).add(mux);
        Element elementOut = mux.getOutputAt(0);
        PointConnection pc = new PointConnection();
        if (this.getGraphicalNodeInParent(elementOut, graphicParent) != null) {
            pc = (PointConnection)this.getGraphicalNodeInParent(elementOut, graphicParent);
        } else {
            pc.setName(elementOut.getName());
            pc.setElement(elementOut);
            pc.setLayout(new Rectangle(0, 0, 10, 10));
            graphicParent.addChild(pc);
        }
        ifThenElse.setOutputPointConnexion(pc);
        pc.setLevel(ifThenElse.getLevel());
        new Connection(nodeIn1, ifThenElse.getTruePoint());
        new Connection(nodeIn2, ifThenElse.getFalsePoint());
        new Connection(ifThenElse.getOutPoint(), pc);
    }

    private void createOperation(Operation operation, Node graphicParent, Vector<Vector<Element>> elementLevel) {
        Node node;
        int maxLevel = 0;
        Vector<Node> inputs = new Vector<Node>();
        for (Element e : operation.getInput()) {
            node = this.getGraphicalNodeInParent(e, graphicParent);
            if (node instanceof GraphicLoopIterator) {
                node = ((GraphicLoopIterator)node).getOutputPointConnection();
            }
            inputs.add(node);
        }
        int i = 0;
        while (i < inputs.size()) {
            node = (Node)inputs.get(i);
            if (node == null) {
                PointConnection pc = new PointConnection();
                pc.setName(String.valueOf(((SimpleVariable)operation.getInputAt(i)).getVal()));
                if (i == 0 && inputs.size() > 1) {
                    pc.setLevel(inputs.get(1) == null ? 0 : ((Node)inputs.get(1)).getLevel());
                } else if (i == 1) {
                    pc.setLevel(inputs.get(0) == null ? 0 : ((Node)inputs.get(0)).getLevel());
                }
                pc.setLayout(new Rectangle(0, 0, 10, 10));
                pc.setElement(operation.getInputAt(i));
                graphicParent.addChild(pc);
                pc.setIsConstant(true);
                inputs.set(i, pc);
            }
            ++i;
        }
        GraphicOperation o = new GraphicOperation();
        o.setName(operation.getName());
        o.setElement(operation);
        o.setOperatorName(operation.getOpSymbol());
        graphicParent.addChild(o);
        for (Node in : inputs) {
            int n = maxLevel = maxLevel < in.getLevel() ? in.getLevel() : maxLevel;
        }
        o.setLevel(maxLevel + 1);
        if (o.getLevel() > elementLevel.size() - 1) {
            elementLevel.add(new Vector());
        }
        elementLevel.elementAt(o.getLevel()).add(operation);
        o.setLayout(new Rectangle(0, 0, 19, 19));
        Element elementOut = operation.getOutput().elementAt(0);
        PointConnection pc = new PointConnection();
        if (this.getGraphicalNodeInParent(elementOut, graphicParent) != null) {
            pc = (PointConnection)this.getGraphicalNodeInParent(elementOut, graphicParent);
        } else {
            pc.setName(elementOut.getName());
            pc.setElement(elementOut);
            pc.setLayout(new Rectangle(0, 0, 10, 10));
            graphicParent.addChild(pc);
        }
        o.setOutputPointConnexion(pc);
        pc.setLevel(o.getLevel());
        for (Node in : inputs) {
            new Connection(in, o);
        }
        new Connection(o, pc);
    }

    private void locateNodesLevel(Vector<Element> level, GraphicFunction graphicFunction) {
        Vector<Node> nodes = new Vector<Node>();
        Point bestLocation = new Point();
        Node nodeOut = null;
        Node nodeIn = null;
        for (Element element : level) {
            if (element instanceof Assignment) {
                nodes.add(this.getGraphicalNodeInParent(((Assignment)element).getOutputAt(0), graphicFunction));
                continue;
            }
            nodes.add(this.getGraphicalNodeInParent(element, graphicFunction));
        }
        for (Node node : nodes) {
            if (node instanceof PointConnection && ((PointConnection)node).getIsConstant() || node.getLevel() == 0) continue;
            int index = nodes.indexOf(node);
            bestLocation = this.getBestLocation(level.elementAt(index), graphicFunction);
            if (node instanceof PointConnection) {
                node.getLayout().setLocation(graphicFunction.getLayout().width, Math.max(40, bestLocation.y - 5));
                continue;
            }
            if (node instanceof GraphicOperation) {
                node.getLayout().setLocation(graphicFunction.getLayout().width, Math.max(40, bestLocation.y - 9));
                continue;
            }
            if (node instanceof GraphicIf) {
                node.getLayout().setLocation(graphicFunction.getLayout().width, Math.max(40, bestLocation.y - 20));
                continue;
            }
            if (node instanceof GraphicLoop) {
                node.getLayout().setLocation(graphicFunction.getLayout().width, Math.max(40, bestLocation.y - node.getLayout().height / 2));
                continue;
            }
            if (!(node instanceof GraphicLoopIterator)) continue;
            node.getLayout().setLocation(graphicFunction.getLayout().width, Math.max(40, bestLocation.y - node.getLayout().height / 2));
        }
        this.elasticLayout(nodes);
        for (Node node : nodes) {
            if (node instanceof PointConnection) {
                graphicFunction.getLayout().setSize(Math.max(graphicFunction.getLayout().width, node.getLayout().x + node.getLayout().width + 40), Math.max(graphicFunction.getLayout().height, node.getLayout().y + node.getLayout().height + 40));
                continue;
            }
            if (node instanceof GraphicOperation) {
                this.locateConstantInput(node.getElement(), graphicFunction);
                nodeOut = ((GraphicOperation)node).getOutputPointConnection();
                nodeOut.getLayout().x = node.getLayout().x + node.getLayout().width + 10;
                nodeOut.getLayout().y = (2 * node.getLayout().y + node.getLayout().height) / 2 - 5;
                graphicFunction.getLayout().setSize(Math.max(graphicFunction.getLayout().width, nodeOut.getLayout().x + nodeOut.getLayout().width + 40), Math.max(graphicFunction.getLayout().height, nodeOut.getLayout().y + nodeOut.getLayout().height + 40));
                continue;
            }
            if (node instanceof GraphicIf) {
                this.locateConstantInput(node.getElement(), graphicFunction);
                nodeOut = ((GraphicIf)node).getOutputPointConnection();
                nodeOut.getLayout().x = node.getLayout().x + node.getLayout().width + 10;
                nodeOut.getLayout().y = (2 * node.getLayout().y + node.getLayout().height) / 2 - 5;
                graphicFunction.getLayout().setSize(Math.max(graphicFunction.getLayout().width, nodeOut.getLayout().x + nodeOut.getLayout().width + 40), Math.max(graphicFunction.getLayout().height, nodeOut.getLayout().y + nodeOut.getLayout().height + 40));
                continue;
            }
            if (node instanceof GraphicLoop) {
                Vector<Node> outputNodes = new Vector<Node>();
                graphicFunction.getLayout().setSize(Math.max(graphicFunction.getLayout().width, node.getLayout().x + node.getLayout().width + 40), Math.max(graphicFunction.getLayout().height, node.getLayout().y + node.getLayout().height + 40));
                for (Element element : ((Function)node.getElement()).getOutput()) {
                    nodeOut = this.getGraphicalNodeInParent(element, graphicFunction);
                    nodeOut.getLayout().x = node.getLayout().x + node.getLayout().width + 15;
                    nodeOut.getLayout().y = node.getLayout().y + this.getGraphicalNodeInParent((Element)element, (Node)node).getLayout().y;
                    nodeOut.getLayout().setSize(10, 10);
                    ((GraphicLoop)node).addOutputPointConnection((PointConnection)nodeOut);
                    outputNodes.add(nodeOut);
                    new Connection(this.getGraphicalNodeInParent(element, node), this.getGraphicalNodeInParent(element, graphicFunction));
                    graphicFunction.getLayout().setSize(Math.max(graphicFunction.getLayout().width, nodeOut.getLayout().x + nodeOut.getLayout().width + 40), Math.max(graphicFunction.getLayout().height, node.getLayout().y + node.getLayout().height + 40));
                }
                this.elasticLayout(outputNodes);
                for (Element element : ((Function)node.getElement()).getInput()) {
                    nodeIn = this.getGraphicalNodeInParent(element, graphicFunction);
                    if (!((Variable)nodeIn.getElement()).getType().equals("const")) continue;
                    nodeIn.getLayout().x = node.getLayout().x - 30;
                    nodeIn.getLayout().y = node.getLayout().y + this.getGraphicalNodeInParent((Element)element, (Node)node).getLayout().y + 1;
                }
                continue;
            }
            if (!(node instanceof GraphicLoopIterator)) continue;
            nodeOut = ((GraphicLoopIterator)node).getOutputPointConnection();
            nodeOut.getLayout().x = node.getLayout().x + node.getLayout().width + 10;
            nodeOut.getLayout().y = (2 * node.getLayout().y + node.getLayout().height) / 2 - 5 + 2;
            graphicFunction.getLayout().setSize(Math.max(graphicFunction.getLayout().width, nodeOut.getLayout().x + nodeOut.getLayout().width + 40), Math.max(graphicFunction.getLayout().height, nodeOut.getLayout().y + nodeOut.getLayout().height + 40));
        }
    }

    private Point getBestLocation(Element element, GraphicFunction graphicFunction) {
        Point point = new Point();
        Node parentNode = this.getGraphicalNodeInParent(element, graphicFunction);
        if (element instanceof Operation && ((Operation)element).getInput().size() == 1) {
            Node nodeIn1 = this.getGraphicalNodeInParent(((Operation)element).getInputAt(0), graphicFunction);
            point.setLocation(0, nodeIn1.getLayout().y + nodeIn1.getLayout().height / 2);
        } else if (element instanceof Operation) {
            Node nodeIn1 = this.getGraphicalNodeInParent(((Operation)element).getInputAt(0), graphicFunction);
            Node nodeIn2 = this.getGraphicalNodeInParent(((Operation)element).getInputAt(1), graphicFunction);
            if (nodeIn1 instanceof GraphicLoopIterator) {
                nodeIn1 = ((GraphicLoopIterator)nodeIn1).getOutputPointConnection();
            }
            if (nodeIn2 instanceof GraphicLoopIterator) {
                nodeIn2 = ((GraphicLoopIterator)nodeIn2).getOutputPointConnection();
            }
            if (!((PointConnection)nodeIn1).getIsConstant() && !((PointConnection)nodeIn2).getIsConstant()) {
                point.setLocation(0, (nodeIn1.getLayout().y + nodeIn2.getLayout().y + nodeIn2.getLayout().height) / 2);
            } else if (((PointConnection)nodeIn1).getIsConstant() && ((PointConnection)nodeIn2).getIsConstant()) {
                point.setLocation(0, 40 + this.getGraphicalNodeInParent((Element)element, (Node)graphicFunction).getLayout().height / 2);
            } else if (((PointConnection)nodeIn1).getIsConstant()) {
                point.setLocation(0, nodeIn2.getLayout().y + nodeIn2.getLayout().height / 2);
            } else if (((PointConnection)nodeIn2).getIsConstant()) {
                point.setLocation(0, nodeIn1.getLayout().y + nodeIn1.getLayout().height / 2);
            }
        } else if (element instanceof IfThenElse) {
            Node nodeIn1 = this.getGraphicalNodeInParent(((Assignment)((IfThenElse)element).getBodyTrue().firstElement()).getInputAt(0), graphicFunction);
            Node nodeIn2 = this.getGraphicalNodeInParent(((Assignment)((IfThenElse)element).getBodyFalse().firstElement()).getInputAt(0), graphicFunction);
            if (nodeIn1 instanceof GraphicLoopIterator) {
                nodeIn1 = ((GraphicLoopIterator)nodeIn1).getOutputPointConnection();
            }
            if (nodeIn2 instanceof GraphicLoopIterator) {
                nodeIn2 = ((GraphicLoopIterator)nodeIn2).getOutputPointConnection();
            }
            if (nodeIn1.getLevel() > parentNode.getLevel()) {
                point.setLocation(0, nodeIn2.getLayout().y + nodeIn2.getLayout().height / 2);
            } else if (nodeIn2.getLevel() > parentNode.getLevel()) {
                point.setLocation(0, nodeIn1.getLayout().y + nodeIn1.getLayout().height / 2);
            }
        } else if (element instanceof Function) {
            Node firstInputNode = this.getGraphicalNodeInParent(((Function)element).getInput().lastElement(), graphicFunction);
            Node lastInputNode = this.getGraphicalNodeInParent(((Function)element).getInput().lastElement(), graphicFunction);
            point.setLocation(0, (firstInputNode.getLayout().y + lastInputNode.getLayout().y) / 2);
        } else {
            point.setLocation(0, 40);
        }
        return point;
    }

    private void locateConstantInput(Element element, Node graphicParent) {
        if (!(element instanceof Assignment) && !(element instanceof Function)) {
            Vector<Node> inputs = new Vector<Node>();
            Rectangle layoutParent = this.getGraphicalNodeInParent(element, graphicParent).getLayout();
            for (Element e : ((Operation)element).getInput()) {
                Node node = this.getGraphicalNodeInParent(e, graphicParent);
                if (node instanceof GraphicLoopIterator) {
                    node = ((GraphicLoopIterator)node).getOutputPointConnection();
                }
                inputs.add(node);
            }
            if (element instanceof Multiplexer) {
                int i = 0;
                while (i < inputs.size()) {
                    Node node = (Node)inputs.get(i);
                    if (((PointConnection)node).getIsConstant()) {
                        node.getLayout().setLocation(layoutParent.x - 20, layoutParent.y + 5 + i * 19);
                    }
                    ++i;
                }
            } else if (element instanceof Operation) {
                if (inputs.size() == 2) {
                    Node nodeIn1 = (Node)inputs.elementAt(0);
                    Node nodeIn2 = (Node)inputs.elementAt(1);
                    if (((PointConnection)nodeIn1).getIsConstant() && ((PointConnection)nodeIn2).getIsConstant()) {
                        nodeIn1.getLayout().setLocation(layoutParent.x - 20, layoutParent.y - 5);
                        nodeIn2.getLayout().setLocation(layoutParent.x - 20, layoutParent.y + 15);
                    } else if (((PointConnection)nodeIn1).getIsConstant()) {
                        int value = nodeIn2.getLayout().y > layoutParent.y ? -5 : 15;
                        nodeIn1.getLayout().setLocation(layoutParent.x - 20, layoutParent.y + value);
                    } else if (((PointConnection)nodeIn2).getIsConstant()) {
                        int value = nodeIn1.getLayout().y > layoutParent.y ? -5 : 15;
                        nodeIn2.getLayout().setLocation(layoutParent.x - 20, layoutParent.y + value);
                    }
                } else if (inputs.size() == 1 && ((PointConnection)inputs.elementAt(0)).getIsConstant()) {
                    ((Node)inputs.elementAt(0)).getLayout().setLocation(layoutParent.x - 20, layoutParent.y + 4);
                }
            }
        }
    }

    private void elasticLayout(Vector<Node> nodes) {
        int i = 0;
        while (i < nodes.size()) {
            int j = i;
            while (j < nodes.size()) {
                if (nodes.elementAt((int)i).getLayout().y < nodes.elementAt((int)j).getLayout().y) {
                    Node tempNode = nodes.elementAt(i);
                    nodes.setElementAt(nodes.elementAt(j), i);
                    nodes.setElementAt(tempNode, j);
                }
                ++j;
            }
            ++i;
        }
        for (Node node : nodes) {
            if (nodes.indexOf(node) != nodes.size() - 1) {
                this.deleteSuperpositionUp(nodes, node, nodes.elementAt(nodes.indexOf(node) + 1));
            }
            if (nodes.indexOf(node) == 0) continue;
            this.deleteSuperpositionDown(nodes, node, nodes.elementAt(nodes.indexOf(node) - 1));
        }
    }

    private void deleteSuperpositionDown(Vector<Node> nodes, Node node, Node nextNode) {
        if (nextNode == null) {
            return;
        }
        int dSuperposition = this.distanceSuperposedDown(node, nextNode);
        if (dSuperposition != 0) {
            nextNode.getLayout().y += dSuperposition;
            Node tempNode = nodes.indexOf(nextNode) == 0 ? null : nodes.elementAt(nodes.indexOf(nextNode) - 1);
            this.deleteSuperpositionDown(nodes, nextNode, tempNode);
        }
    }

    private boolean deleteSuperpositionUp(Vector<Node> nodes, Node node, Node nextNode) {
        if (nextNode == null) {
            return node.getLayout().y >= 40;
        }
        int dSuperposition = this.distanceSuperposedUp(node, nextNode);
        if (dSuperposition != 0) {
            nextNode.getLayout().y -= dSuperposition;
            Node tempNode = nodes.indexOf(nextNode) == nodes.size() - 1 ? null : nodes.elementAt(nodes.indexOf(nextNode) + 1);
            if (!this.deleteSuperpositionUp(nodes, nextNode, tempNode)) {
                nextNode.getLayout().y += dSuperposition;
                return false;
            }
        }
        return true;
    }

    private int distanceSuperposedUp(Node nodeTest, Node node) {
        Rectangle nodeLayout = node.getLayout();
        Rectangle nodeLayoutTest = nodeTest.getLayout();
        if (nodeLayoutTest.y < nodeLayout.y + nodeLayout.height + 40) {
            return nodeLayout.y + nodeLayout.height - nodeLayoutTest.y + 40;
        }
        return 0;
    }

    private int distanceSuperposedDown(Node nodeTest, Node node) {
        Rectangle nodeLayout = node.getLayout();
        Rectangle nodeLayoutTest = nodeTest.getLayout();
        if (nodeLayoutTest.y + nodeLayoutTest.height > nodeLayout.y - 40) {
            return nodeLayoutTest.y + nodeLayoutTest.height - nodeLayout.y + 40;
        }
        return 0;
    }

    private String getConditionString(Vector<Element> condition) {
        Vector conditionsNames = new Vector();
        for (Element element : condition) {
            Vector<String> vector = new Vector<String>();
            for (Element element2 : ((Operation)element).getInput()) {
                if (!((Variable)element2).getType().equals("const")) {
                    vector.add(element2.getName());
                    continue;
                }
                vector.add(String.valueOf(((SimpleVariable)element2).getVal()));
            }
            vector.add(((Operation)element).getOpSymbol());
            vector.add(((Operation)element).getOutputAt(0).getName());
            conditionsNames.add(vector);
        }
        for (Vector vector : conditionsNames) {
            for (Vector vector2 : conditionsNames) {
                if (((String)vector2.lastElement()).equalsIgnoreCase((String)vector.elementAt(0))) {
                    if (vector2.size() != 3) {
                        vector.setElementAt(String.valueOf((String)vector2.elementAt(0)) + " " + (String)vector2.elementAt(2) + " " + (String)vector2.elementAt(1), 0);
                    } else {
                        vector.setElementAt(String.valueOf((String)vector2.elementAt(1)) + (String)vector2.elementAt(0), 0);
                    }
                }
                if (vector.size() == 3 || !((String)vector2.lastElement()).equalsIgnoreCase((String)vector.elementAt(1))) continue;
                vector.setElementAt(String.valueOf((String)vector2.elementAt(0)) + " " + (String)vector2.elementAt(2) + " " + (String)vector2.elementAt(1), 1);
            }
        }
        if (((Vector)conditionsNames.lastElement()).size() != 3) {
            return String.valueOf((String)((Vector)conditionsNames.lastElement()).elementAt(0)) + " " + (String)((Vector)conditionsNames.lastElement()).elementAt(2) + " " + (String)((Vector)conditionsNames.lastElement()).elementAt(1);
        }
        return String.valueOf((String)((Vector)conditionsNames.lastElement()).elementAt(1)) + (String)((Vector)conditionsNames.lastElement()).elementAt(0);
    }

    private Node getGraphicalNodeInParent(Element element, Node parent) {
        for (Node node : parent.getChildrenArray()) {
            if (element != node.getElement()) continue;
            return node;
        }
        return null;
    }

    private Node getGraphicalNode(Element element) {
        LinkedList<Node> nodeList = new LinkedList<Node>();
        nodeList.addAll(this.schema.getChildrenArray());
        Iterator iterNode = nodeList.iterator();
        while (iterNode.hasNext()) {
            Node node = (Node)iterNode.next();
            if (element == node.getElement()) {
                return node;
            }
            if (node.getChildrenArray().size() != 0) {
                nodeList.addAll(node.getChildrenArray());
            }
            nodeList.remove(nodeList.indexOf(node));
            iterNode = nodeList.iterator();
        }
        return null;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

