/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.editPart;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import m2m.frontend.dynamicview.editPart.AbstractEditPart;
import m2m.frontend.dynamicview.editpolicies.EditLayoutPolicy;
import m2m.frontend.dynamicview.figure.SchemaFigure;
import m2m.frontend.dynamicview.model.BendPoint;
import m2m.frontend.dynamicview.model.Connection;
import m2m.frontend.dynamicview.model.GraphicFunction;
import m2m.frontend.dynamicview.model.GraphicOperation;
import m2m.frontend.dynamicview.model.InternPointConnection;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.Schema;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;

public class SchemaPart
extends AbstractEditPart {
    private static int BUSY_POINT = -1;
    private static int FREE_POINT = Integer.MAX_VALUE;
    private static int CONNECTION_POINT = 0x7FFFFFFE;
    private static int FUNCTION_POINT = 0x7FFFFFFD;
    private int[][] tabRouter = new int[2000][2000];
    private int[][] tabTemp;

    protected IFigure createFigure() {
        SchemaFigure figure = new SchemaFigure();
        figure.addMouseMotionListener(this);
        figure.addMouseListener(this);
        ((Schema)this.getModel()).setLayout(figure.getBounds());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EditLayoutPolicy());
    }

    public Vector<Node> getModelChildren() {
        return ((Schema)this.getModel()).getChildrenArray();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Layout")) {
            this.refreshVisuals();
        }
    }

    private void routeConnections(Vector<Connection> conList) {
        this.initTabRouter();
        for (Connection con : conList) {
            if (con.getSource() instanceof GraphicOperation) continue;
            Rectangle parentAbsoluteLayout = this.getAbsoluteLayout(this.getOldParent(con.getSource(), con.getTarget()));
            this.tabTemp = new int[parentAbsoluteLayout.width][parentAbsoluteLayout.height];
            int i = 0;
            while (i < this.tabTemp.length) {
                int j = 0;
                while (j < this.tabTemp[i].length) {
                    this.tabTemp[i][j] = i == 0 || i == this.tabTemp.length - 1 || j == 0 || j == this.tabTemp[i].length - 1 ? -1 : this.tabRouter[i + parentAbsoluteLayout.x][j + parentAbsoluteLayout.y];
                    ++j;
                }
                ++i;
            }
            Rectangle startLayout = this.getAbsoluteLayout(con.getSource());
            Rectangle endLayout = this.getAbsoluteLayout(con.getTarget());
            Point startAnchorPoint = this.getAnchorPoint(new Point(startLayout.x + startLayout.width / 2, startLayout.y + startLayout.height / 2));
            startAnchorPoint.performTranslate(-parentAbsoluteLayout.x, -parentAbsoluteLayout.y);
            Point endAnchorPoint = this.getAnchorPoint(new Point(endLayout.x + endLayout.width / 2 - 1, endLayout.y + endLayout.height / 2));
            endAnchorPoint.performTranslate(-parentAbsoluteLayout.x, -parentAbsoluteLayout.y);
            this.tabTemp[startAnchorPoint.x][startAnchorPoint.y] = 1;
            LinkedList<Point> pointList = new LinkedList<Point>();
            pointList.add(startAnchorPoint);
            Point point = new Point(0, 0);
            Point tempPoint = new Point(0, 0);
            int maxDepth = ((Schema)this.getModel()).maxDepth;
            Iterator iterPoint = pointList.iterator();
            while (iterPoint.hasNext()) {
                point.setLocation((Point)iterPoint.next());
                int i2 = 0;
                while (i2 < 4) {
                    int maxCurrentDepth;
                    switch (i2) {
                        case 0: {
                            tempPoint.setLocation(point.x - 1, point.y);
                            break;
                        }
                        case 1: {
                            tempPoint.setLocation(point.x, point.y - 1);
                            break;
                        }
                        case 2: {
                            tempPoint.setLocation(point.x + 1, point.y);
                            break;
                        }
                        case 3: {
                            tempPoint.setLocation(point.x, point.y + 1);
                        }
                    }
                    int valeurTab = this.tabTemp[tempPoint.x][tempPoint.y];
                    int currentDepthSource = con.getSource().getDepthLevel();
                    int currentDepthTarget = con.getTarget().getDepthLevel();
                    int n = maxCurrentDepth = currentDepthSource > currentDepthTarget ? currentDepthSource : currentDepthTarget;
                    if ((valeurTab < FUNCTION_POINT - maxDepth || valeurTab > FUNCTION_POINT - maxCurrentDepth) && valeurTab != BUSY_POINT && valeurTab > this.tabTemp[point.x][point.y] + 1) {
                        if (this.tabRouter[tempPoint.x + parentAbsoluteLayout.x][tempPoint.y + parentAbsoluteLayout.y] == CONNECTION_POINT) {
                            if (valeurTab > this.tabTemp[point.x][point.y] + 10) {
                                this.tabTemp[tempPoint.x][tempPoint.y] = this.tabTemp[point.x][point.y] + 10;
                                pointList.add(new Point(tempPoint.x, tempPoint.y));
                            }
                        } else {
                            this.tabTemp[tempPoint.x][tempPoint.y] = this.tabTemp[point.x][point.y] + 1;
                            pointList.add(new Point(tempPoint.x, tempPoint.y));
                        }
                    }
                    ++i2;
                }
                pointList.remove(pointList.indexOf(point));
                iterPoint = pointList.iterator();
            }
            this.findBestWay(endAnchorPoint, startAnchorPoint, new Point(endLayout.x + endLayout.width / 2 - 1, endLayout.y + endLayout.height / 2), new Point(startLayout.x + startLayout.width / 2, startLayout.y + startLayout.height / 2), con);
        }
    }

    private void initTabRouter() {
        Schema schema = (Schema)this.getModel();
        Rectangle rectTemp = new Rectangle(0, 0, 0, 0);
        int i = 0;
        while (i < this.tabRouter.length) {
            int j = 0;
            while (j < this.tabRouter[i].length) {
                this.tabRouter[i][j] = i == 0 || i == this.tabRouter.length - 1 || j == 0 || j == this.tabRouter[i].length - 1 ? BUSY_POINT : FREE_POINT;
                ++j;
            }
            ++i;
        }
        LinkedList<Node> nodeList = new LinkedList<Node>();
        nodeList.addAll(schema.getChildrenArray());
        Iterator iterNode = nodeList.iterator();
        while (iterNode.hasNext()) {
            Node node = (Node)iterNode.next();
            if (node.getVisible()) {
                int j;
                if (node.getChildrenArray().size() != 0) {
                    nodeList.addAll(node.getChildrenArray());
                }
                rectTemp = this.getAbsoluteLayout(node);
                if (!(node instanceof GraphicFunction)) {
                    int i2 = rectTemp.x - 5;
                    while (i2 < rectTemp.x + rectTemp.width + 5) {
                        j = rectTemp.y - 5;
                        while (j < rectTemp.y + rectTemp.height + 5) {
                            this.tabRouter[i2][j] = BUSY_POINT;
                            ++j;
                        }
                        ++i2;
                    }
                } else {
                    int depthLevel = node.getDepthLevel();
                    int i3 = rectTemp.x - 5;
                    while (i3 <= rectTemp.x + rectTemp.width + 5) {
                        this.tabRouter[i3][rectTemp.y - 5] = FUNCTION_POINT - depthLevel;
                        this.tabRouter[i3][rectTemp.y + rectTemp.height + 5] = FUNCTION_POINT - depthLevel;
                        ++i3;
                    }
                    j = rectTemp.y - 5;
                    while (j <= rectTemp.y + rectTemp.height + 5) {
                        this.tabRouter[rectTemp.x - 5][j] = FUNCTION_POINT - depthLevel;
                        this.tabRouter[rectTemp.x + rectTemp.width + 5][j] = FUNCTION_POINT - depthLevel;
                        ++j;
                    }
                }
            }
            nodeList.remove(nodeList.indexOf(node));
            iterNode = nodeList.iterator();
        }
    }

    private Rectangle getAbsoluteLayout(Node node) {
        Rectangle layout = new Rectangle(0, 0, node.getLayout().width, node.getLayout().height);
        Node nodeTemp = node;
        while (!(nodeTemp instanceof Schema)) {
            layout.x += nodeTemp.getLayout().x;
            layout.y += nodeTemp.getLayout().y;
            nodeTemp = nodeTemp.getParent();
        }
        return layout;
    }

    private Point getAnchorPoint(Point point) {
        Point[] tabPoint = new Point[]{new Point(point.x - 1, point.y), new Point(point.x, point.y - 1), new Point(point.x + 1, point.y), new Point(point.x, point.y + 1)};
        block6: while (true) {
            int i = 0;
            while (true) {
                if (i >= tabPoint.length) continue block6;
                if (this.tabRouter[tabPoint[i].x][tabPoint[i].y] != -1) {
                    return tabPoint[i];
                }
                switch (i) {
                    case 0: {
                        --tabPoint[i].x;
                        break;
                    }
                    case 1: {
                        --tabPoint[i].y;
                        break;
                    }
                    case 2: {
                        ++tabPoint[i].x;
                        break;
                    }
                    case 3: {
                        ++tabPoint[i].y;
                    }
                }
                ++i;
            }
            break;
        }
    }

    private void findBestWay(Point endAnchorPoint, Point startAnchorPoint, Point endPoint, Point startPoint, Connection con) {
        Rectangle parentAbsoluteLayout = this.getAbsoluteLayout(this.getOldParent(con.getSource(), con.getTarget()));
        Point currentPoint = new Point(endAnchorPoint);
        Point nextPoint = new Point(0, 0);
        Point tempPoint = new Point(0, 0);
        startAnchorPoint.performTranslate(parentAbsoluteLayout.x, parentAbsoluteLayout.y);
        endAnchorPoint.performTranslate(parentAbsoluteLayout.x, parentAbsoluteLayout.y);
        int minValue = this.tabTemp[currentPoint.x][currentPoint.y];
        int temSens = 0;
        int sens = 0;
        sens = this.getSens(endPoint, endAnchorPoint);
        con.getBendPoints().removeAll(con.getBendPoints());
        while (minValue != 1) {
            int i = 0;
            while (i < 4) {
                switch (i) {
                    case 0: {
                        tempPoint.setLocation(currentPoint.x - 1, currentPoint.y);
                        break;
                    }
                    case 1: {
                        tempPoint.setLocation(currentPoint.x, currentPoint.y - 1);
                        break;
                    }
                    case 2: {
                        tempPoint.setLocation(currentPoint.x + 1, currentPoint.y);
                        break;
                    }
                    case 3: {
                        tempPoint.setLocation(currentPoint.x, currentPoint.y + 1);
                    }
                }
                if (this.tabTemp[tempPoint.x][tempPoint.y] < minValue && this.tabTemp[tempPoint.x][tempPoint.y] != -1) {
                    minValue = this.tabTemp[tempPoint.x][tempPoint.y];
                    nextPoint.setLocation(tempPoint);
                    temSens = i;
                }
                ++i;
            }
            this.tabRouter[nextPoint.x + parentAbsoluteLayout.x][nextPoint.y + parentAbsoluteLayout.y] = CONNECTION_POINT;
            i = 1;
            while (i < 6) {
                int j = 0;
                while (j < 7) {
                    switch (j) {
                        case 0: {
                            tempPoint.setLocation(nextPoint.x - i, nextPoint.y);
                            break;
                        }
                        case 1: {
                            tempPoint.setLocation(nextPoint.x, nextPoint.y - i);
                            break;
                        }
                        case 2: {
                            tempPoint.setLocation(nextPoint.x + i, nextPoint.y);
                            break;
                        }
                        case 3: {
                            tempPoint.setLocation(nextPoint.x, nextPoint.y + i);
                            break;
                        }
                        case 4: {
                            tempPoint.setLocation(nextPoint.x - i, nextPoint.y + i);
                            break;
                        }
                        case 5: {
                            tempPoint.setLocation(nextPoint.x - i, nextPoint.y - i);
                            break;
                        }
                        case 6: {
                            tempPoint.setLocation(nextPoint.x + i, nextPoint.y - i);
                            break;
                        }
                        case 7: {
                            tempPoint.setLocation(nextPoint.x + i, nextPoint.y + i);
                        }
                    }
                    tempPoint.performTranslate(parentAbsoluteLayout.x, parentAbsoluteLayout.y);
                    if (tempPoint.x < this.tabRouter.length && tempPoint.y < this.tabRouter[0].length && this.tabRouter[tempPoint.x][tempPoint.y] != -1 && this.tabRouter[tempPoint.x][tempPoint.y] != FUNCTION_POINT) {
                        this.tabRouter[tempPoint.x][tempPoint.y] = CONNECTION_POINT;
                    }
                    ++j;
                }
                ++i;
            }
            if (sens != temSens) {
                BendPoint bp = new BendPoint();
                currentPoint.performTranslate(parentAbsoluteLayout.x, parentAbsoluteLayout.y);
                bp.setHeight(currentPoint.getDifference((Point)startPoint).height, currentPoint.getDifference((Point)endPoint).height);
                bp.setWidth(currentPoint.getDifference((Point)startPoint).width, currentPoint.getDifference((Point)endPoint).width);
                bp.setConnection(con);
                bp.setIndex(0);
                con.addBendPoint(bp);
                sens = temSens;
            }
            currentPoint.setLocation(nextPoint);
        }
        sens = this.getSens(startPoint, startAnchorPoint);
        if (sens != temSens) {
            BendPoint bp = new BendPoint();
            currentPoint.performTranslate(parentAbsoluteLayout.x, parentAbsoluteLayout.y);
            bp.setHeight(currentPoint.getDifference((Point)startPoint).height, currentPoint.getDifference((Point)endPoint).height);
            bp.setWidth(currentPoint.getDifference((Point)startPoint).width, currentPoint.getDifference((Point)endPoint).width);
            bp.setConnection(con);
            bp.setIndex(0);
            con.addBendPoint(bp);
            sens = temSens;
        }
    }

    public void Intersections() {
        Vector<Connection> routeConList = new Vector<Connection>();
        Vector<Connection> conList = new Vector<Connection>();
        Vector<Node> nodeList = new Vector<Node>();
        LinkedList<Node> tempNodeList = new LinkedList<Node>();
        nodeList.addAll(((Schema)this.getModel()).getChildrenArray());
        tempNodeList.addAll(((Schema)this.getModel()).getChildrenArray());
        Iterator iterNode = tempNodeList.iterator();
        while (iterNode.hasNext()) {
            Node tempNode = (Node)iterNode.next();
            if (tempNode.getChildrenArray().size() != 0) {
                nodeList.addAll(tempNode.getChildrenArray());
                tempNodeList.addAll(tempNode.getChildrenArray());
            }
            conList.addAll(tempNode.getSourceConnections());
            tempNodeList.remove(tempNodeList.indexOf(tempNode));
            iterNode = tempNodeList.iterator();
        }
        for (Connection con : conList) {
            if (!con.getMustBeRoute()) continue;
            for (Node node : nodeList) {
                if (node == con.getSource() || node == con.getTarget() || !node.getVisible() || !con.getTarget().getVisible() || !con.getSource().getVisible() || !con.getVisible()) continue;
                if (node instanceof GraphicFunction) {
                    if (node.getDepthLevel() < con.getSource().getDepthLevel() || node.getDepthLevel() < con.getTarget().getDepthLevel() || !this.connectionNodeIntersection(con, this.getAbsoluteLayout(node)) || routeConList.contains(con)) continue;
                    routeConList.add(con);
                    continue;
                }
                if (!this.connectionNodeIntersection(con, this.getAbsoluteLayout(node)) || routeConList.contains(con)) continue;
                routeConList.add(con);
            }
            if (routeConList.contains(con)) continue;
            con.removeAllBendPoint();
        }
        this.routeConnections(routeConList);
    }

    private boolean connectionNodeIntersection(Connection con, Rectangle layout) {
        Rectangle startNodeLayout = this.getAbsoluteLayout(con.getSource());
        Rectangle endNodeLayout = this.getAbsoluteLayout(con.getTarget());
        Point A = new Point(startNodeLayout.x + startNodeLayout.width / 2, startNodeLayout.y + startNodeLayout.height / 2);
        Point B = new Point(endNodeLayout.x + endNodeLayout.width / 2, endNodeLayout.y + endNodeLayout.height / 2);
        if (this.segmentIntersection(A, B, new Point(layout.x, layout.y), new Point(layout.x, layout.y + layout.height)) && !(con.getTarget() instanceof InternPointConnection)) {
            return true;
        }
        if (this.segmentIntersection(A, B, new Point(layout.x, layout.y), new Point(layout.x + layout.width, layout.y))) {
            return true;
        }
        if (this.segmentIntersection(A, B, new Point(layout.x, layout.y + layout.height), new Point(layout.x + layout.width, layout.y + layout.height))) {
            return true;
        }
        return this.segmentIntersection(A, B, new Point(layout.x + layout.width, layout.y), new Point(layout.x + layout.width, layout.y + layout.height)) && !(con.getSource() instanceof InternPointConnection);
    }

    private boolean segmentIntersection(Point a1, Point a2, Point b1, Point b2) {
        int d = (a1.x - a2.x) * (b1.y - b2.y) - (a1.y - a2.y) * (b1.x - b2.x);
        if (d == 0) {
            return false;
        }
        int xi = ((b1.x - b2.x) * (a1.x * a2.y - a1.y * a2.x) - (a1.x - a2.x) * (b1.x * b2.y - b1.y * b2.x)) / d;
        int yi = ((b1.y - b2.y) * (a1.x * a2.y - a1.y * a2.x) - (a1.y - a2.y) * (b1.x * b2.y - b1.y * b2.x)) / d;
        if (xi < Math.min(a1.x, a2.x) || xi > Math.max(a1.x, a2.x)) {
            return false;
        }
        if (xi < Math.min(b1.x, b2.x) || xi > Math.max(b1.x, b2.x)) {
            return false;
        }
        if (yi < Math.min(a1.y, a2.y) || yi > Math.max(a1.y, a2.y)) {
            return false;
        }
        return yi >= Math.min(b1.y, b2.y) && yi <= Math.max(b1.y, b2.y);
    }

    private int getSens(Point point, Point anchorPoint) {
        if (Math.abs(point.x - anchorPoint.x) > 4) {
            if (point.x > anchorPoint.x) {
                return 0;
            }
            return 2;
        }
        if (Math.abs(point.y - anchorPoint.y) > 4) {
            if (point.y > anchorPoint.y) {
                return 1;
            }
            return 3;
        }
        return -1;
    }

    private Node getOldParent(Node nodeSource, Node nodeTarget) {
        Rectangle parentTargetLayout;
        Rectangle parentSourceLayout = this.getAbsoluteLayout(nodeSource.getParent());
        return parentSourceLayout.contains(parentTargetLayout = this.getAbsoluteLayout(nodeTarget.getParent())) ? nodeSource.getParent() : nodeTarget.getParent();
    }

    public int[][] getTabRouter() {
        return this.tabRouter;
    }
}

