/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.figure;

import m2m.frontend.dynamicview.model.Connection;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConnectionPropertyFigure
extends Figure
implements ActionListener {
    private XYLayout layout;
    private Connection conn;
    private Label labelSourceName = new Label();
    private Label labelTargetName = new Label();
    private Button btnDeleteBendPoints;
    private Button btnRoute;
    private CheckBox checkBoxAutoRoute = new CheckBox("Automatic route");

    public ConnectionPropertyFigure() {
        this.layout = new XYLayout();
        this.setLayoutManager((LayoutManager)this.layout);
        this.labelSourceName.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelSourceName, false);
        this.setConstraint((IFigure)this.labelSourceName, new Rectangle(0, 0, -1, -1));
        this.labelSourceName.setText("Unknown");
        this.labelTargetName.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelTargetName, false);
        this.setConstraint((IFigure)this.labelTargetName, new Rectangle(0, 15, -1, -1));
        this.labelTargetName.setText("Unknown");
        this.btnDeleteBendPoints = new Button("Delete all bend points");
        this.add((IFigure)this.btnDeleteBendPoints);
        this.setConstraint((IFigure)this.btnDeleteBendPoints, new Rectangle(0, 45, -1, -1));
        this.btnDeleteBendPoints.addActionListener((ActionListener)this);
        this.btnRoute = new Button("Route connections");
        this.add((IFigure)this.btnRoute);
        this.setConstraint((IFigure)this.btnRoute, new Rectangle(0, 75, -1, -1));
        this.btnRoute.addActionListener((ActionListener)this);
        this.add((IFigure)this.checkBoxAutoRoute);
        this.setConstraint((IFigure)this.checkBoxAutoRoute, new Rectangle(0, 105, -1, -1));
        this.checkBoxAutoRoute.addActionListener((ActionListener)this);
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.menuBackground);
        this.setForegroundColor(ColorConstants.menuForeground);
    }

    public void setProperty(Connection conn) {
        this.conn = conn;
        this.labelSourceName.setText("Source : " + conn.getSource().getName());
        this.labelTargetName.setText("Target : " + conn.getTarget().getName());
        this.btnDeleteBendPoints.setEnabled(!conn.getBendPoints().isEmpty());
        this.checkBoxAutoRoute.setSelected(conn.getMustBeRoute());
    }

    public void actionPerformed(ActionEvent arg) {
        if (arg.getSource() == this.btnDeleteBendPoints) {
            this.conn.removeAllBendPoint();
            this.btnDeleteBendPoints.setEnabled(false);
        } else if (arg.getSource() == this.btnRoute) {
            this.conn.route();
        } else if (arg.getSource() == this.checkBoxAutoRoute) {
            this.conn.setMustBeRoute(this.checkBoxAutoRoute.isSelected());
        }
    }
}

