/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.figure;

import m2m.backend.buildingblocks.BuildingBlock;
import m2m.frontend.dynamicview.model.Schema;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class SchemaPropertyFigure
extends Figure
implements ActionListener {
    private Schema schema;
    private XYLayout layout;
    private CheckBox checkBox32Bits = new CheckBox("FLOAT32 architecture");
    private CheckBox checkBox64Bits = new CheckBox("FLOAT64 architecture");
    private CheckBox checkBoxFifoOpti = new CheckBox("Optimize Fifos");
    private CheckBox checkBoxFifoComp = new CheckBox("Add Compensation Fifos");
    private Label warning = new Label();

    public SchemaPropertyFigure(Schema schema) {
        this.schema = schema;
        this.layout = new XYLayout();
        this.setLayoutManager((LayoutManager)this.layout);
        this.add((IFigure)this.checkBox32Bits);
        this.setConstraint((IFigure)this.checkBox32Bits, new Rectangle(0, 0, -1, -1));
        this.checkBox32Bits.addActionListener((ActionListener)this);
        this.add((IFigure)this.checkBox64Bits);
        this.setConstraint((IFigure)this.checkBox64Bits, new Rectangle(0, 15, -1, -1));
        this.checkBox64Bits.addActionListener((ActionListener)this);
        this.add((IFigure)this.checkBoxFifoOpti);
        this.setConstraint((IFigure)this.checkBoxFifoOpti, new Rectangle(0, 45, -1, -1));
        this.checkBoxFifoOpti.addActionListener((ActionListener)this);
        this.add((IFigure)this.checkBoxFifoComp);
        this.setConstraint((IFigure)this.checkBoxFifoComp, new Rectangle(0, 60, -1, -1));
        this.checkBoxFifoComp.addActionListener((ActionListener)this);
        this.warning.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.warning, false);
        this.setConstraint((IFigure)this.warning, new Rectangle(0, 90, -1, -1));
        this.warning.setText("Warning: make sure that the fifos value is sufficient.");
        this.warning.setForegroundColor(ColorConstants.red);
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.menuBackground);
        this.setForegroundColor(ColorConstants.menuForeground);
    }

    public void setProperty() {
        this.checkBox32Bits.setSelected(this.schema.getDataType() == BuildingBlock.NumType.FLOAT32);
        this.checkBox64Bits.setSelected(this.schema.getDataType() == BuildingBlock.NumType.FLOAT64);
        this.checkBoxFifoComp.setSelected(this.schema.getFifoComp());
        this.checkBoxFifoOpti.setSelected(this.schema.getFifoOpti());
        this.warning.setVisible(!this.schema.getFifoOpti());
    }

    public void actionPerformed(ActionEvent arg) {
        if (arg.getSource() == this.checkBox32Bits) {
            this.schema.setDataType(BuildingBlock.NumType.FLOAT32);
        } else if (arg.getSource() == this.checkBox64Bits) {
            this.schema.setDataType(BuildingBlock.NumType.FLOAT64);
        }
        this.checkBox32Bits.setSelected(this.schema.getDataType() == BuildingBlock.NumType.FLOAT32);
        this.checkBox64Bits.setSelected(this.schema.getDataType() == BuildingBlock.NumType.FLOAT64);
        if (arg.getSource() == this.checkBoxFifoComp) {
            this.schema.setFifoComp(this.checkBoxFifoComp.isSelected());
        }
        if (arg.getSource() == this.checkBoxFifoOpti) {
            this.schema.setFifoOpti(this.checkBoxFifoOpti.isSelected());
        }
        this.schema.setModified(true);
        this.warning.setVisible(!this.schema.getFifoOpti());
    }
}

