/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import m2m.frontend.dynamicview.model.BendPoint;
import m2m.frontend.dynamicview.model.Node;
import org.eclipse.draw2d.geometry.Dimension;

public class Connection {
    public static final String VISIBLE_CONNECTION = "VisibleConnection";
    public static final String BENDPOINT_POSITION = "BendPointPosition";
    public static final String ROUTE_CONNECTION = "RouteConnection";
    private PropertyChangeSupport listeners;
    private int lineStyle = 1;
    private Node source;
    private Node target;
    private boolean visible = true;
    private boolean mustBeRoute = true;
    private Vector<BendPoint> bendPoints = new Vector();

    public Connection(Node source, Node target) {
        this.source = source;
        this.target = target;
        this.source.addConnection(this);
        this.target.addConnection(this);
        this.listeners = new PropertyChangeSupport(this);
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getTarget() {
        return this.target;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean odlValue = this.visible;
        this.visible = visible;
        this.firePropertyChange(VISIBLE_CONNECTION, odlValue, visible);
    }

    public boolean getMustBeRoute() {
        return this.mustBeRoute;
    }

    public void setMustBeRoute(boolean val) {
        this.mustBeRoute = val;
    }

    public Vector<BendPoint> getBendPoints() {
        return this.bendPoints;
    }

    public void addBendPoint(BendPoint bp) {
        this.bendPoints.add(bp.getIndex(), bp);
        this.firePropertyChange(BENDPOINT_POSITION, null, this.bendPoints);
        this.firePropertyChange("Property", null, this.bendPoints);
    }

    public void removeBendPoint(int index) {
        this.bendPoints.remove(index);
        this.firePropertyChange(BENDPOINT_POSITION, null, this.bendPoints);
        this.firePropertyChange("Property", null, this.bendPoints);
    }

    public void removeAllBendPoint() {
        this.bendPoints.removeAll(this.bendPoints);
        this.firePropertyChange(BENDPOINT_POSITION, null, this.bendPoints);
    }

    public void modifyBendPoint(int index, Dimension d1, Dimension d2) {
        BendPoint oldBp;
        BendPoint NewBp = oldBp = this.bendPoints.get(index);
        NewBp.setHeight(d1.height, d2.height);
        NewBp.setWidth(d1.width, d2.width);
        this.firePropertyChange(BENDPOINT_POSITION, null, NewBp);
    }

    public void route() {
        this.firePropertyChange(ROUTE_CONNECTION, null, this);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.listeners.hasListeners(property)) {
            this.listeners.firePropertyChange(property, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void refreshConnection() {
        this.firePropertyChange(BENDPOINT_POSITION, null, this.bendPoints);
        this.firePropertyChange("Property", null, this.bendPoints);
    }
}

