/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.model;

import java.util.Vector;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.Multiplexer;
import m2m.backend.structure.Operation;
import m2m.backend.structure.StructTreatment;
import m2m.frontend.dynamicview.model.InternPointConnection;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.PointConnection;
import m2m.frontend.view.Editor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.PlatformUI;

public class GraphicIf
extends Node {
    private String condition;
    private InternPointConnection truePoint = new InternPointConnection();
    private InternPointConnection falsePoint = new InternPointConnection();
    private InternPointConnection outPoint = new InternPointConnection();
    private PointConnection outputPointConnection = null;
    private Vector<Node> conditionNodes = new Vector();

    public GraphicIf() {
        this.truePoint.setName("true");
        this.truePoint.setParent(this);
        this.truePoint.setLayout(new Rectangle(0, 8, 5, 5));
        this.falsePoint.setName("false");
        this.falsePoint.setParent(this);
        this.falsePoint.setLayout(new Rectangle(0, 27, 5, 5));
        this.outPoint.setName("out");
        this.outPoint.setParent(this);
        this.outPoint.setLayout(new Rectangle(35, 17, 5, 5));
    }

    public PointConnection getOutputPointConnection() {
        return this.outputPointConnection;
    }

    public void setOutputPointConnexion(PointConnection pc) {
        this.outputPointConnection = pc;
        pc.setOutputResult(this);
    }

    public boolean getMonitor() {
        if (this.getElement() instanceof Multiplexer) {
            return ((Multiplexer)this.getElement()).getSel().getMonitor();
        }
        return ((Operation)((IfThenElse)this.getElement()).getCond().firstElement()).getInputAt(0).getMonitor();
    }

    public void setMonitor(boolean monitor) {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        StructTreatment treatment = editor.getM2MProject().getStructTreatment();
        if (this.getElement() instanceof Multiplexer) {
            ((Multiplexer)this.getElement()).getSel().setMonitor(monitor, treatment);
        } else {
            ((Operation)((IfThenElse)this.getElement()).getCond().firstElement()).getInputAt(0).setMonitor(monitor, treatment);
        }
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        this.condition = cond;
    }

    public InternPointConnection getTruePoint() {
        return this.truePoint;
    }

    public InternPointConnection getFalsePoint() {
        return this.falsePoint;
    }

    public InternPointConnection getOutPoint() {
        return this.outPoint;
    }

    public void addConditionNodes(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.conditionNodes.add(node);
    }

    public void removeConditionNodes(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.conditionNodes.remove(node);
    }

    public Vector<Node> getConditionNodes() {
        return this.conditionNodes;
    }

    @Override
    public Vector<Node> getChildrenArray() {
        Vector<Node> children = new Vector<Node>();
        children.add(this.truePoint);
        children.add(this.falsePoint);
        children.add(this.outPoint);
        return children;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.truePoint.setVisible(visible);
        this.falsePoint.setVisible(visible);
        this.outPoint.setVisible(visible);
    }

    @Override
    public boolean CanSetLayout(Rectangle layoutTest) {
        if (!this.isInParent(layoutTest)) {
            return false;
        }
        for (Node node : this.getParent().getChildrenArray()) {
            if (node == this || node == this.outputPointConnection || !this.nodeUnderNode(layoutTest, node.getLayout())) continue;
            return false;
        }
        return true;
    }
}

