/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.model;

import java.util.Vector;
import m2m.backend.structure.Operation;
import m2m.backend.structure.StructTreatment;
import m2m.frontend.dynamicview.model.InternPointConnection;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.PointConnection;
import m2m.frontend.view.Editor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.PlatformUI;

public class GraphicLoopIterator
extends Node {
    private boolean selectAll;
    private String startInitialisation;
    private String incrementation;
    private String endCondition;
    private InternPointConnection outPoint = new InternPointConnection();
    private PointConnection outputPointConnection = null;
    private Vector<Node> conditionNodes = new Vector();
    private Operation iterOperation;

    public GraphicLoopIterator() {
        this.startInitialisation = "Unknown";
        this.incrementation = "Unknown";
        this.endCondition = "Unknown";
        this.outPoint.setName("out");
        this.outPoint.setParent(this);
        this.outPoint.setLayout(new Rectangle(33, 15, 5, 5));
        this.iterOperation = null;
    }

    public GraphicLoopIterator(String startInit, String inc, String endCond, Operation op) {
        this.startInitialisation = startInit;
        this.incrementation = inc;
        this.endCondition = endCond;
        this.outPoint.setName("out");
        this.outPoint.setParent(this);
        this.outPoint.setLayout(new Rectangle(33, 15, 5, 5));
        this.iterOperation = op;
    }

    public boolean getMonitor() {
        return this.getElement().getMonitor();
    }

    public void setMonitor(boolean monitor) {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        StructTreatment treatment = editor.getM2MProject().getStructTreatment();
        this.getElement().setMonitor(monitor, treatment);
    }

    public String getStartInitialisation() {
        return this.startInitialisation;
    }

    public void setStartInitialisation(String startInit) {
        this.startInitialisation = startInit;
    }

    public String getIncrementation() {
        return this.incrementation;
    }

    public void setIncrementation(String inc) {
        this.incrementation = inc;
    }

    public String getEndCondition() {
        return this.endCondition;
    }

    public void setEndCondition(String endCond) {
        this.endCondition = endCond;
    }

    public InternPointConnection getOutPoint() {
        return this.outPoint;
    }

    @Override
    public Vector<Node> getChildrenArray() {
        Vector<Node> children = new Vector<Node>();
        children.add(this.outPoint);
        return children;
    }

    public void addConditionNodes(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.conditionNodes.add(node);
    }

    public void removeConditionNodes(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.conditionNodes.remove(node);
    }

    public Vector<Node> getConditionNodes() {
        return this.conditionNodes;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.outPoint.setVisible(visible);
    }

    public PointConnection getOutputPointConnection() {
        return this.outputPointConnection;
    }

    public void setOutputPointConnexion(PointConnection pc) {
        this.outputPointConnection = pc;
        pc.setOutputResult(this);
    }

    public Operation getIterOperation() {
        return this.iterOperation;
    }

    public void setIterOperation(Operation op) {
        this.iterOperation = op;
    }

    public void setSelectAll(boolean val) {
        this.selectAll = val;
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    @Override
    public boolean CanSetLayout(Rectangle layoutTest) {
        if (!this.isInParent(layoutTest)) {
            return false;
        }
        for (Node node : this.getParent().getChildrenArray()) {
            if (node == this || node == this.outputPointConnection || !this.nodeUnderNode(layoutTest, node.getLayout())) continue;
            return false;
        }
        return true;
    }
}

