/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import m2m.backend.structure.Element;
import m2m.frontend.dynamicview.model.Connection;
import m2m.frontend.dynamicview.model.InternPointConnection;
import m2m.frontend.dynamicview.model.Schema;
import m2m.frontend.view.Editor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class Node {
    public static final String LAYOUT = "Layout";
    public static final String VISIBLE_COMPONENT = "VisibleComponent";
    public static final String CHANGE_COLOR = "ChangeColor";
    private String name = "Unknown";
    private Rectangle layout;
    private Vector<Rectangle> layoutReduction = new Vector();
    private Vector<Node> children;
    private Node parent = null;
    private boolean visible = true;
    private PropertyChangeSupport listeners;
    private Vector<Connection> sourceConnections = new Vector();
    private Vector<Connection> targetConnections = new Vector();
    private boolean colorConditionSelected = false;
    private int level;
    private int depthLevel;
    private Element element;

    public Node() {
        this.layout = new Rectangle(10, 10, 100, 100);
        this.children = new Vector();
        this.listeners = new PropertyChangeSupport(this);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.add(conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.add(conn);
        }
    }

    public void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
        }
    }

    public Vector<Connection> getSourceConnections() {
        return this.sourceConnections;
    }

    public Vector<Connection> getTargetConnections() {
        return this.targetConnections;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean odlValue = this.visible;
        this.visible = visible;
        this.firePropertyChange(VISIBLE_COMPONENT, odlValue, visible);
    }

    public void setLayout(Rectangle newLayout) {
        Rectangle oldLayout = this.layout;
        this.layout = newLayout;
        this.getListeners().firePropertyChange(LAYOUT, oldLayout, newLayout);
    }

    public void setLayoutReduction(Rectangle newLayout) {
        this.layoutReduction.add(0, new Rectangle(this.layout));
        this.layout = newLayout;
        this.getListeners().firePropertyChange(LAYOUT, this.layoutReduction.firstElement(), newLayout);
    }

    public Rectangle getLayout() {
        return this.layout;
    }

    public Rectangle getLayoutReduction() {
        return this.layoutReduction.firstElement();
    }

    public void removeLayoutReduction() {
        this.layoutReduction.remove(this.layoutReduction.firstElement());
    }

    public void addChild(Node child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public Vector<Node> getChildrenArray() {
        return this.children;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean getColorConditionSelected() {
        return this.colorConditionSelected;
    }

    public void setColorConditionSelected(boolean colorConditionSelected) {
        boolean odlValue = this.colorConditionSelected;
        this.colorConditionSelected = colorConditionSelected;
        this.firePropertyChange(CHANGE_COLOR, odlValue, colorConditionSelected);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public PropertyChangeSupport getListeners() {
        return this.listeners;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.listeners.hasListeners(property)) {
            this.listeners.firePropertyChange(property, oldValue, newValue);
        }
    }

    public boolean CanSetLayout(Rectangle layoutTest) {
        for (Node node : this.parent.getChildrenArray()) {
            if (node == this || !this.nodeUnderNode(layoutTest, node.getLayout())) continue;
            return false;
        }
        return true;
    }

    public boolean nodeUnderNode(Rectangle layoutTest, Rectangle layoutNode) {
        Rectangle tempLayoutTest = new Rectangle(layoutTest.x - 5, layoutTest.y - 5, layoutTest.width + 10, layoutTest.height + 10);
        Rectangle tempLayoutNode = new Rectangle(layoutNode.x - 5, layoutNode.y - 5, layoutNode.width + 10, layoutNode.height + 10);
        return tempLayoutTest.intersects(tempLayoutNode);
    }

    public boolean isInParent(Rectangle layoutTest) {
        Rectangle parentLayout = this.parent.getLayout();
        if (layoutTest.x < 0 || layoutTest.y < 0) {
            return false;
        }
        return this.parent instanceof Schema || layoutTest.x + layoutTest.width <= parentLayout.width && layoutTest.y + layoutTest.height <= parentLayout.height;
    }

    public void setDepthLevel() {
        Node node = this;
        int level = 0;
        while (!(node instanceof Schema)) {
            if (node instanceof InternPointConnection) {
                node = node.getParent();
            }
            ++level;
            node = node.getParent();
        }
        this.depthLevel = level;
    }

    public int getDepthLevel() {
        return this.depthLevel;
    }

    public void setModified(boolean value) {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof Editor) {
            ((Editor)editorPart).setModified(value);
        }
    }
}

