-------------------------------------------------------------------------------
-- HEIG-VD, Haute Ecole d'Ingenierie et de Gestion du canton de Vaud
-- Institut REDS, Reconfigurable & Embedded Digital Systems
--
-- Fichier      : Counter_Rd.vhd
-- Description  : simple counter for m2m loops, without loading
-- 
-- Auteur       : SMS
-- Date         : 13.04.2010
-- Version      : 0.0
-- 
-- Utilise      : Math2Mat
-- 
--| Modifications |------------------------------------------------------------
-- Version   Auteur Date               Description
-- 
-------------------------------------------------------------------------------

library ieee;
    use ieee.std_logic_1164.all;
    use ieee.numeric_std.all;
    use work.log_pkg.all;

entity Counter_Rd is
    generic(Size_g : integer := 64);
    port(Clock_i   : in std_logic;
         Reset_i : in std_logic;
         En_i    : in std_logic;
         Ready_i : in std_logic;
         Count_o : out std_logic_vector(ilogup(Size_g)-1 downto 0)
        );
end Counter_Rd;

architecture comport of Counter_Rd is

    signal Count_s     : unsigned(ilogup(size_g)-1 downto 0);
    signal Count_Mem_s : unsigned(ilogup(size_g)-1 downto 0);
    signal Ready_s     : std_logic;

begin

	Count_o <= std_logic_vector(Count_s) when Ready_i = '1' else std_logic_vector(Count_Mem_s);

    process(Clock_i, Reset_i)
    begin
        if Reset_i = '1' then
            Count_s <= (others => '0');
        elsif Rising_Edge(Clock_i) then
            if En_i = '1' and Ready_s = '1' then
                if Count_s = (Size_g-1) then
                    Count_s <= (others => '0');
                else
                    Count_s <= Count_s + 1;
                end if;
            end if;
        end if;
    end process;

    process(Clock_i, Reset_i)
    begin
        if (Reset_i = '1') then
            Count_Mem_s <= (others => '0');
            Ready_s <= '1';
		elsif Rising_Edge(Clock_i) then
			if (Ready_i = '1') then
                Count_Mem_s <= Count_s;
			end if;
			Ready_s <= Ready_i;
		end if;
	end process;
    
end comport;