-----------------------------------------------------------
-- Math2mat project
-- Created:
--          by - Samuel Tche
--          at - 04.02.2009
--
-- Package definition: 
-- Constants and functions
-----------------------------------------------------------

--***********************************************
--         PACKAGE definition
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;
package pkg_definition is 
   constant m_c : integer := 32;
      
   Constant latency1_c : Integer := 1;
   Constant delay1_c : Integer := 4;

   Constant latency2_c : Integer := 1;
   Constant delay2_c : Integer := 1;
  
   Constant latency3_c : Integer := 0;
   Constant delay3_c : Integer := 0;
   
   function count_zeros(signal mant_s : std_logic_vector) return unsigned;
 
end pkg_definition;

package body pkg_definition is
   -- compte le nombre de zero depuis la gauche    
   function count_zeros(signal mant_s : std_logic_vector) return unsigned is
   variable count : unsigned(5 downto 0);
   begin
      count := "000000";
      for i in mant_s'range loop
         case mant_s(i) is
            when '0' => count := count + "1";
            when others => exit;         
         end case;    
      end loop;   
      return count;  
   end count_zeros;

end pkg_definition;


