library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity fifo_Std is
	generic (
		FIFOSIZE  : integer := 32;
		DATAWIDTH : integer := 32
	);
	port (
		Clock_i      		: in    std_logic;
		Reset_i      		: in    std_logic;
		Wr_Req_i     		: in    std_logic;
		Rd_Req_i    		: in    std_logic;
		Data_i       		: in    std_logic_vector(DATAWIDTH-1 downto 0);
		Fifo_Full_o  		: out   std_logic;
		Fifo_Empty_o		: out   std_logic;
		Data_o       		: out   std_logic_vector(DATAWIDTH-1 downto 0)
	);
end fifo_Std;

architecture behave of fifo_Std is

	type   fifo_type is array(0 to FIFOSIZE-1) of std_logic_vector(DATAWIDTH-1 downto 0);
	signal fifo: fifo_type;
	signal fifo_counter_in: integer range 0 to FIFOSIZE-1;
	signal fifo_counter_out: integer range 0 to FIFOSIZE-1;
	signal new_fifo_counter_out: integer range 0 to FIFOSIZE-1;
	signal new_fifo_counter_in: integer range 0 to FIFOSIZE-1;
	signal fifo_full: std_logic;
	signal fifo_empty: std_logic;
	signal fifo_rd: std_logic;
	signal fifo_wr: std_logic;
	signal fifo_select_mem: std_logic;
	signal fifo_out_mem: std_logic_vector(DATAWIDTH-1 downto 0);
	signal fifo_out_bypass: std_logic_vector(DATAWIDTH-1 downto 0);
	signal Data_s: std_logic_vector(DATAWIDTH-1 downto 0);

begin

	Data_s  <= fifo_out_mem	when fifo_select_mem = '1' else
			   fifo_out_bypass;
	
	Data_o <= Data_s;
	
	fifo_wr      <= Wr_Req_i;
	fifo_rd      <= Rd_Req_i;	
	
	Fifo_Empty_o <= fifo_empty;
	Fifo_Full_o  <= fifo_full;	
	
	new_fifo_counter_out <= 0 when fifo_counter_out=FIFOSIZE-1 else fifo_counter_out+1;
	new_fifo_counter_in <= 0 when fifo_counter_in=FIFOSIZE-1 else fifo_counter_in+1;
	
	process(Clock_i)
	begin
    if Reset_i = '1' then
      fifo_out_bypass <= (others => '0');
		elsif rising_edge(Clock_i) then
			fifo_out_bypass <= Data_s;
			if (fifo_wr = '1' and fifo_empty = '1') or ((fifo_rd = '1' and fifo_wr = '1') and (((new_fifo_counter_out)) = fifo_counter_in)) then
				fifo_out_bypass <= Data_i;
			end if;
		end if;
	end process;
	
	process(Clock_i)
	begin
    if Reset_i = '1' then
      fifo_select_mem <= '0';
      fifo_out_mem <= (others => '0');
		elsif rising_edge(Clock_i) then
				fifo_select_mem <= '0';
			if (fifo_rd = '1' and fifo_empty = '0') and  not((fifo_rd = '1' and fifo_wr = '1') and (((new_fifo_counter_out)) = fifo_counter_in))then
				fifo_out_mem <= fifo((new_fifo_counter_out));
				fifo_select_mem <= '1';
			end if;
		end if;
	end process;
	
	process(Clock_i, Reset_i)
	begin
		if Reset_i = '1' then
			fifo_counter_in  <= 0;
			fifo_counter_out <= 0;
			fifo_full        <= '0';
			fifo_empty       <= '1';
		elsif rising_edge(Clock_i) then
			if fifo_rd = '1' and fifo_empty = '0' then
				fifo_full <= '0';
				if fifo_wr = '0' or fifo_full = '1' then
					if ((new_fifo_counter_out)) = fifo_counter_in then
						fifo_empty <= '1';
					end if;
				end if;
				fifo_counter_out <= (new_fifo_counter_out);
			end if;
			
			if fifo_wr = '1' and fifo_full = '0' then
				fifo_empty <= '0';
				if fifo_rd = '0' or fifo_empty = '1' then
					if ((new_fifo_counter_in)) = fifo_counter_out then
						fifo_full <= '1';
					end if;
				end if;
				fifo_counter_in       <= (new_fifo_counter_in);
				fifo(fifo_counter_in) <= Data_i;
			end if;
		end if;
	end process;

end behave;
