-------------------------------------------------------------------------------
-- HEIG-VD, Haute Ecole d'Ingenierie et de Gestion du canton de Vaud
-- Institut REDS, Reconfigurable & Embedded Digital Systems
--
-- Fichier      : orLogic.vhd
--
-- Description  : 
-- 
-- Auteur       : SMS
-- Date         : 27.10.2009
-- Version      : 0.0
-- 
-- Utilise      : 
-- 
--| Modifications |------------------------------------------------------------
-- Version   Auteur Date               Description
-- 
-------------------------------------------------------------------------------
library ieee;
  use ieee.std_logic_1164.all;

entity orLogic is
	generic ( wValid_g : integer := 1 );
    port(
		clk_i 	: in std_logic;
		reset_i : in std_logic;
		valid_i : in std_logic_vector(wValid_g-1 downto 0);
		stall_i : in std_logic;
		D1_i	: in std_logic;
		D2_i	: in std_logic;
		m_o     : out std_logic;
		valid_o : out std_logic_vector(wValid_g-1 downto 0);
		ready_o : out std_logic 
    );
end orLogic;

architecture comp of orLogic is
begin
    
    Valid_o  <= valid_i;
	
    ready_o  <= not stall_i;
    
    m_o <= D1_i or D2_i;
			 
end architecture;