///////////////////////////////////////////////////////////////////////////////
// HEIG-VD, Haute Ecole d'Ingenierie et de Gestion du canton de Vaud
// Institut REDS, Reconfigurable & Embedded Digital Systems
//
// File         : M2M_env.sv
//
// Description  :
//
// Author       : S. Masle
// Date         : 19.10.2009
// Version      : 0.0
//
// Use          : testbench for Math2Mat
//
//| Modifications |////////////////////////////////////////////////////////////
// Version   Author Date               Description
//  01.00     guo   20100416            add OVM reporting
//  01.01     guo   20100429            add Reporting
//  01.02     guo   20100503            add Timing Checker
//  01.03     guo   20100816            add Internal Component and Checker
///////////////////////////////////////////////////////////////////////////////

`ifndef M2M_ENV__SV
`define M2M_ENV__SV

`include "macros.sv"
`include "bases.sv"
`include "M2M_input_classes.sv"
`include "M2M_output_classes.sv"
`include "M2M_checker.sv"
`include "M2M_internal_classes.sv"

/**
* This class defines the testbench environment. It declares the components
* used in the testbench.
*
*/
class M2M_env extends Component;

  // Three components in this testbench:
  // one M2M_Input_Component, one M2M_Out_Component, one M2M_Checker.
  M2M_Input_Component   M2M_in_comp;
  M2M_Out_Component     M2M_out_comp;
  M2M_Checker           M2M_check;
  M2M_Timing_Checker    M2M_timing_check;
  M2M_Internal_Component  M2M_int_comp;
  M2M_Internals_Checker   M2M_int_check;

  function new(
      string _name, Component _parent,
      virtual M2M_input_intf  M2M_in_hook,
      virtual M2M_output_intf M2M_out_hook,
      virtual M2M_internal_intf M2M_int_hook
    );

    super.new( _name, _parent );

    // Construct the Input and Output components and
    // connect them to the DUT using virtual interfaces.
    M2M_in_comp  = new( "M2M_in_comp", this, M2M_in_hook );
    M2M_out_comp = new( "M2M_out_comp", this, M2M_out_hook );
    M2M_int_comp = new( "M2M_int_comp", this, M2M_int_hook );

    // Construct the checker component as a child of this
    // top-leve environment
    M2M_check         = new( "check", this );
    M2M_timing_check  = new( "timing_check", this );
    M2M_int_check     = new( "internal_check", this );

    // Connect the checker component's two channel references
    // to the M2M_Input_Component and M2M_Out_Component's analysis outputs.
    M2M_check.sink = M2M_out_comp.analysis;
    M2M_timing_check.sink_inputs = M2M_in_comp.analysis;
    M2M_timing_check.sink_outputs = M2M_out_comp.analysis;
    M2M_int_check.sink = M2M_int_comp.analysis;

  endfunction : new

  // body() method must be overridden, but has no real work to do
  // because this is a wrapper component
  //
  task body();

   `M2M_REPORT_INFO({get_hier_name(), " body begin"})

  endtask

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  // Configuration methods to adjust the stimulus and coverage
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  // set_num_trans: Configure the number of transactions that will
  //                be generated by the Input stimulus generator
  //
/*  function void set_num_trans(int N);
    M2M_in_comp.stim_gen.num_trans = N;
    $display("configured %s.num_trans = %0d",
               M2M_in_comp.stim_gen.get_hier_name(), N );
  endfunction : set_num_trans
*/
  // set_stim_template: Configure the template object instance
  //                    used by the Input stimulus generator for
  //                    stimulus randomization
  //
/*  function void set_stim_template(M2M_Input_Trans t);
    M2M_in_comp.stim_gen.template = t;
    $display("configured %s.template =\n     %s",
               M2M_in_comp.stim_gen.get_hier_name(), t.psprint() );
  endfunction : set_stim_template
*/
  // set_mon_template: Configure the template object instance
  //                   used by the Input monitor for collecting
  //                   monitored transactions
  //
/*  function void set_mon_template(M2M_Input_Trans t);
    M2M_in_comp.monitor.template = t;
    $display("configured %s.template =\n     %s",
               M2M_in_comp.monitor.get_hier_name(), t.psprint() );
  endfunction : set_mon_template
*/
  /** set_par_template: Configure the template object instance
  *   used by the output monitor for collecting monitored transactions.
  *
  * @param M2M_Out_Trans t the template transaction.
  */
/*  function void set_par_template(M2M_Out_Trans t);
    M2M_out_comp.monitor.template = t;
    $display("configured %s.template =\n     %s",
               M2M_out_comp.monitor.get_hier_name(), t.psprint() );
  endfunction : set_par_template
*/
endclass : M2M_env

