-----------------------------------------------------------------------------
-- Math2mat project
-- Created:
--          by - Samuel Tche
--          at - 04.02.2009
------------------------------------------------------------------------------

--***********************************************
--               sqrt_comb_srt2_32
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_comb_srt2_32 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (31 downto 0);
    m_o     : out std_logic_vector(31 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_comb_srt2_32;

architecture struct of sqrt_comb_srt2_32 is

begin  
  
div_inst : Sqrt
generic map
   (m_g       => 32,
    pipe_g    => 0,
    latency_g => latency_g,
    type_g    => 0,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_comb_srt2_64
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_comb_srt2_64 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (63 downto 0);
    m_o     : out std_logic_vector(63 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_comb_srt2_64;

architecture struct of sqrt_comb_srt2_64 is
begin
div_inst : Sqrt
generic map
   (m_g       => 64,
    pipe_g    => 0,
    latency_g => latency_g,
    type_g    => 0,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_pipe_srt2_32
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_pipe_srt2_32 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (31 downto 0);
    m_o     : out std_logic_vector(31 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_pipe_srt2_32;

architecture struct of sqrt_pipe_srt2_32 is

begin  
div_inst : Sqrt
generic map
   (m_g       => 32,
    pipe_g    => 1,
    latency_g => 0,
    type_g    => 0,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_pipe_srt2_64
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_pipe_srt2_64 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (63 downto 0);
    m_o     : out std_logic_vector(63 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_pipe_srt2_64;

architecture struct of sqrt_pipe_srt2_64 is

begin  
div_inst : Sqrt
generic map
   (m_g       => 64,
    pipe_g    => 1,
    latency_g => 0,
    type_g    => 0,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_comb_nr_32
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_comb_nr_32 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (31 downto 0);
    m_o     : out std_logic_vector(31 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_comb_nr_32;

architecture struct of sqrt_comb_nr_32 is

begin  

div_inst : Sqrt
generic map
   (m_g       => 32,
    pipe_g    => 0,
    latency_g => latency_g,
    type_g    => 1,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_comb_nr_64
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_comb_nr_64 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (63 downto 0);
    m_o     : out std_logic_vector(63 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_comb_nr_64;

architecture struct of sqrt_comb_nr_64 is

begin   
div_inst : Sqrt
generic map
   (m_g       => 64,
    pipe_g    => 0,
    latency_g => latency_g,
    type_g    => 1,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_pipe_nr_32
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_pipe_nr_32 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (31 downto 0);
    m_o     : out std_logic_vector(31 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_pipe_nr_32;

architecture struct of sqrt_pipe_nr_32 is

begin  
div_inst : Sqrt
generic map
   (m_g       => 32,
    pipe_g    => 1,
    latency_g => 0,
    type_g    => 1,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;

--***********************************************
--               sqrt_pipe_nr_64
--***********************************************
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use work.pkg_cell.all;

entity sqrt_pipe_nr_64 is
generic
   (latency_g : integer := 0;
    wValid_g  : integer := 1);
port
   (valid_i : in std_logic_vector(wValid_g-1 downto 0);
    clk_i   : in std_logic;
    reset_i : in std_logic;
    stall_i : in std_logic;
    D1_i    : in std_logic_vector (63 downto 0);
    m_o     : out std_logic_vector(63 downto 0);
    valid_o : out std_logic_vector(wValid_g-1 downto 0);
    ready_o : out std_logic);
end sqrt_pipe_nr_64;

architecture struct of sqrt_pipe_nr_64 is

begin  
div_inst : Sqrt
generic map
   (m_g       => 64,
    pipe_g    => 1,
    latency_g => 0,
    type_g    => 1,
    wValid_g  => 1)
port map
   (valid_i 	=> valid_i,
   	clk_i 	  => clk_i,
	 reset_i		=> reset_i,
	 stall_i  => stall_i,
   	D1_i    	=> D1_i,
   	m_o      => m_o,
   	valid_o  => valid_o,
   	ready_o  => ready_o
  	);
end struct;